% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMatrix.R
\name{CMImat2vec}
\alias{CMImat2vec}
\title{Normalized Conditional Mutual Information Between Matrix and Vector}
\usage{
CMImat2vec(mat, vec, condi, bin = 6, sp_order = 2)
}
\arguments{
\item{mat}{A numeric matrix. For example, each row represents a gene and each column represents a sample.}

\item{vec}{A numeric vector, with length equal to the number of columns in `mat`.}

\item{condi}{A numeric condition vector, matching the number of columns in `mat`.}

\item{bin}{An integer specifying the number of bins. Default is 6.}

\item{sp_order}{An integer specifying the spline order. Must be less than `bin`. Default is 2.}
}
\value{
A numeric vector representing the normalized conditional mutual information (CMI) between each row of `mat` and `vec`, given `condi`.
}
\description{
Computes the normalized conditional mutual information (CMI) between each row of a matrix and a vector,
given a third condition vector, normalized by the mutual information of the vector with itself using the specified bins and spline order.
}
\examples{
mat <- matrix(rnorm(10000), nrow = 100, ncol = 100)
vec <- rnorm(100)
condi <- rnorm(100)
CMImat2vec(mat, vec, condi)

}
