% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apportion_scores_multivariate.R
\name{apportion_scores_mv}
\alias{apportion_scores_mv}
\title{Apportions outlier scores to composites.}
\usage{
apportion_scores_mv(obj)
}
\arguments{
\item{obj}{The output of \code{comp_tsout_ens}}
}
\value{
A list with the following components:
\item{\code{scores_out}}{The apportioned outlier scores of selected outliers as per code{mv_tsout_ens}.}
\item{\code{scores_all}}{The apportioned outlier scores of all identified outliers.}
}
\description{
Apportions outlier scores to composites.
}
\examples{
\dontrun{
set.seed(1)
n <- 600
x <- sample(1:100, n, replace=TRUE)
x[25] <- 200
x[320] <- 300
x2 <- sample(1:100, n, replace=TRUE)
x3 <- sample(1:100, n, replace=TRUE)
x4 <- sample(1:100, n, replace=TRUE)
X <- cbind.data.frame(x, x2, x3, x4)
out <- mv_tsout_ens(X, compr=2, fast=FALSE)
apportioned <- apportion_scores_mv(out)
}

}
