% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite_coodinates.R
\name{get_coords}
\alias{get_coords}
\title{Computes unconstrained null space coodinates for compositional data.}
\usage{
get_coords(x)
}
\arguments{
\item{x}{Compositional data in a dataframe or matrix. The rows need to add up to a constrant value}
}
\value{
A list with the following components:
\item{\code{y}}{The unconstrained coordinates of the input}
\item{\code{vec}}{The basis vectors for the null space coordinates}
}
\description{
Computes unconstrained null space coodinates for compositional data.
}
\examples{
set.seed(100)
n <- 600
x <- sample(1:100, n, replace=TRUE)
x2 <- sample(1:100, n, replace=TRUE)
x3 <- sample(1:100, n, replace=TRUE)
x4 <- sample(1:100, n, replace=TRUE)
X <- cbind.data.frame(x, x2, x3, x4)
X <- X/apply(X, 1, sum)
out <- get_coords(X)

}
