% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairgames.R
\name{pairgames}
\alias{pairgames}
\alias{to_pairgames}
\alias{is_pairgames}
\title{Competition results with games between two players}
\usage{
to_pairgames(cr_data)

is_pairgames(cr_data)
}
\arguments{
\item{cr_data}{Competition results in format ready for \code{\link[=as_longcr]{as_longcr()}}.}
}
\value{
\code{to_pairgames()} returns a competition results of pairwise games as
\link{widecr} object with two players.

\code{is_pairgames()} returns a boolean value of whether \code{cr_data} contains only
games between two players.
}
\description{
Functions for competition results with games between two players.
}
\details{
Pairgames is a term for competition results with games between two
players.

\code{to_pairgames()} is a function that converts competition results into
pairwise games: it drops games with one player and for every game with 3 and
more players this function transforms it into set of separate games between
unordered pairs of players. In other words the result is a set of unordered
\link[=get_matchups]{matchups} (\strong{as different games}) between different
players.

\strong{Important notes}:
\itemize{
\item New game identifiers are integers, order of which respects order of
games stored in \code{cr_data} (based on first occurrence in long format). There
is no particular order in subgames of games with 3 and more players.
\item Order in which players are assigned to \code{player1} or \code{player2} column in
general shouldn't agree with any order in \code{cr_data}.
\item Any column except \code{game}, \code{player} and \code{score} will be dropped after
conversion to \link{longcr}.
\item \code{NA} and \code{NaN} in \code{players} are allowed. They are treated as different
players.
\item \code{to_pairgames()} is rather compute-intensive and can take much time for
competition results with many games.
}
}
\examples{
cr_data <- data.frame(
  game = c(rep(1:5, each = 3), 6),
  player = c(rep(1:5, times = 3), 1),
  score = 101:116,
  extraCol = -(1:16)
)

to_pairgames(cr_data)

# Missing values
cr_data_na <- data.frame(
  game = rep(1L, 3),
  player = c(1, NA, NA),
  score = 1:3
)
to_pairgames(cr_data_na)

# Checks
is_pairgames(cr_data)
is_pairgames(to_pairgames(cr_data))
}
