% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiassoc.R
\name{multiassoc}
\alias{multiassoc}
\title{Multiple PGS Associations from a Data Frame}
\usage{
multiassoc(
  df = NULL,
  assoc_table = NULL,
  scale = TRUE,
  covar_col = NA,
  verbose = TRUE,
  log = "",
  parallel = FALSE,
  num_cores = NA
)
}
\arguments{
\item{df}{a dataframe with individuals on each row, and at least the following
columns:
\itemize{
\item one ID column,
\item one PGS column, with numerical continuous values following a normal distribution,
\item one Phenotype column, can be numeric (Continuous Phenotype), character, boolean or factors (Discrete Phenotype)
}}

\item{assoc_table}{a dataframe or matrix specifying the associations to
make from df, with 2 columns: PGS and Phenotype (in this order)}

\item{scale}{a boolean specifying if scaling of PGS should be done before testing}

\item{covar_col}{a character vector specifying the covariate column names (facultative)}

\item{verbose}{a boolean (TRUE by default) to write in the console/log messages.}

\item{log}{a connection, or a character string naming the file to print to.
If "" (by default), it prints to the standard output connection, the console unless redirected by sink.
If parallel = TRUE, the log will be incomplete}

\item{parallel}{a boolean, if TRUE, \code{multiassoc()} parallelise the association analysis to run it faster (no log available with this option, does not work with Windows machine)
If FALSE (default), the association analysis will not be parallelised (useful for debugging process)}

\item{num_cores}{an integer, if parallel = TRUE (default), \code{multiassoc()} parallelise the association analysis to run it faster using num_cores as the number of cores.
If nothing is provided, it detects the number of cores of the machine and use num_cores-1}
}
\value{
return a data frame showing the association of the PGS(s) on the Phenotype(s)
with the following columns:
\itemize{
\item PGS: the name of the PGS
\item Phenotype: the name of Phenotype
\item Phenotype_type: either \code{'Continuous'}, \code{'Ordered Categorical'}, \code{'Categorical'} or \code{'Cases/Controls'}
\item Stat_method: association function detects what is the phenotype type and what is the best way to analyse it, either \code{'Linear regression'}, \code{'Binary logistic regression'}, \code{'Ordinal logistic regression'} or \code{'Multinomial logistic regression'}
\item Covar: list all the covariates used for this association
\item N_cases: if Phenotype_type is Cases/Controls, gives the number of cases
\item N_controls: if Phenotype_type is Cases/Controls, gives the number of controls
\item N: the number of individuals/samples
\item Effect: if Phenotype_type is Continuous, it represents the Beta coefficient of linear regression, OR of logistic regression otherwise
\item SE: standard error of the related Effect (Beta or OR)
\item lower_CI: lower confidence interval of the related Effect (Beta or OR)
\item upper_CI: upper confidence interval of the related Effect (Beta or OR)
\item P_value: associated P-value
}
}
\description{
\code{multiassoc()} take a data frame with distribution(s) of PGS and Phenotype(s),
and a table of associations to make from this data frame

return a data frame showing the association results
}
\examples{
assoc_table <- expand.grid(
  c("t2d_PGS", "ldl_PGS"),
  c("ethnicity","brc","t2d","log_ldl","sbp_cat")
)
results <- multiassoc(
  df = comorbidData,
  assoc_table = assoc_table,
  covar_col = c("age", "sex", "gen_array"),
  parallel = FALSE,
  verbose = FALSE
)
print(results)

}
