% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iperm.R
\name{iperm}
\alias{iperm}
\alias{ipermv}
\title{Permutation Iterator}
\usage{
iperm(n, k = n)

ipermv(values, k = length(values))
}
\arguments{
\item{n}{positive integer}

\item{k}{positive integer}

\item{values}{iterable (subsettable by \code{[})}
}
\value{
iterator object
}
\description{
Create an iterator for all permutations of size k of integers 1 to n.
}
\details{
\itemize{
\item{\code{iperm} iterates through integer vectors}
\item{\code{ipermv} iterates through general values}
}
}
\examples{
x <- iperm(3)
ct <- 0
while (hasNext(x))
{
  ct <- ct + 1
  i <- nextElem(x)
  cat(sprintf("\%3d : \%s\\n", ct, paste0(i, collapse = " ")))
}


as.list(ipermv(c("R", "G", "B")))
}
