% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Franck_test.R
\name{Franck.test}
\alias{Franck.test}
\title{Franck's (2013) et al. test for Interaction}
\usage{
Franck.test(
  x,
  nsim = 10000,
  alpha = 0.05,
  report = TRUE,
  plot = FALSE,
  vecolor = c("blue", "red"),
  linetype = c(1, 2),
  Elapsed.time = TRUE
)
}
\arguments{
\item{x}{numeric matrix, \eqn{a \times b} data matrix where the number of row and column is corresponding to the number of factor levels.}

\item{nsim}{a numeric value, the number of Monte Carlo samples for computing an exact Monte Carlo p-value. The default value is 10000.}

\item{alpha}{a numeric value, the level of the test. The default value is 0.05.}

\item{report}{logical: if \code{TRUE} the result of the test is reported at the \code{alpha} level.}

\item{plot}{logical: if \code{TRUE} an interaction plot will be plotted.}

\item{vecolor}{character vector of length two, for visualizing the colors of lines in interaction plot. The default value is blue and red.}

\item{linetype}{numeric vector of length two, for visualizing the line types in interaction plot. The default value is one and two.}

\item{Elapsed.time}{logical: if \code{TRUE} the progress will be printed in the console.}
}
\value{
An object of the class \code{ITtest}, which is a list inducing following components::
\item{pvalue.exact}{The calculated exact Monte Carlo p-value.}
\item{pvalue.appro}{The Bonferroni-adjusted p-value is calculated.}
\item{statistic}{The value of the test statistic.}
\item{Nsim}{The number of Monte Carlo samples that are used to estimate p-value.}
\item{data.name}{The name of the input dataset.}
\item{test}{The name of the test.}
\item{Level}{The level of test.}
\item{Result}{The result of the test at the alpha level with some descriptions on the type of significant interaction.}
}
\description{
This function calculates Franck's (2013) et al. test statistic, ACMIF, and corresponding p-value.
}
\details{
Franck et al. (2013) derived a test statistic based on the “hidden additivity” structure.
 They defined this structure as “the levels of one factor belong in two or more groups such that within each group the effects of the two factors are additive but the groups may interact with the ungrouped factor”.
 To detect hidden additivity, Franck et al. (2013) divided the table of data into two sub-tables (based on the rows of the data matrix) and an interaction F-test was developed.
 Then, they performed a search over all possible configures of data and used the maximum of the interaction F-test as a test statistic. The hypothesis of no interaction is rejected when the maximum interaction F-test is large.
 If \code{plot} is \code{TRUE} an interaction plot will be plotted by displaying levels of column factor on the horizontal axis,
 levels of row factor using lines that are visually distinguished by line type and color, and the
 observed values on the vertical axis. Color and line type are used to display which levels of row factor are assigned to which
 groups based on the maximum F-values among all possible configurations. Note
 that the grouping colors and line types appear whether or not the Franck.test detects
 a significant non-additivity. The default colors are blue and red, and the default line types are one and two for the two groups. They can be customized by supplying arguments called \code{vecolor} and \code{linetype}.
 Note that the number of rows should be greater than two to perform the Franck.test. This test is powerful when there is a hidden additivity structure in the data set.
}
\examples{
data(CNV)
Franck.test(CNV, nsim = 1000, Elapsed.time = FALSE)

}
\references{
Franck, C., Nielsen, D., Osborne, J.A. (2013). A method for detecting hidden additivity in two-factor unreplicated experiments.
 Computational Statistics and Data Analysis 67:95-104.

 Franck, C., Osborne, J.A. (2016).  Exploring Interaction Effects in Two-Factor Studies using the hidden Package in R.
 R Journal 8 (1):159-172.

 Shenavari, Z., Kharrati-Kopaei, M. (2018). A Method for Testing Additivity in
 Unreplicated Two-Way Layouts Based on Combining Multiple Interaction Tests. International Statistical Review
 86(3): 469-487.
}
