% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colourWidget.R
\name{colourWidget}
\alias{colourWidget}
\title{Create a colour picker htmlwidget}
\usage{
colourWidget(value = "white", showColour = c("both", "text", "background"),
  palette = c("square", "limited"), allowedCols, width = "300px",
  height = "35px", elementId = NULL)
}
\arguments{
\item{value}{Initial value (can be a colour name or HEX code)}

\item{showColour}{Whether to show the chosen colour as text inside the input,
as the background colour of the input, or both (default).}

\item{palette}{The type of colour palette to allow the user to select colours
from. \code{square} (default) shows a square colour palette that allows the
user to choose any colour, while \code{limited} only gives the user a
predefined list of colours to choose from.}

\item{allowedCols}{A list of colours that the user can choose from. Only
applicable when \code{palette == "limited"}. The \code{limited} palette
uses a default list of 40 colours if \code{allowedCols} is not defined.}

\item{width}{Custom width for the input field.}

\item{height}{Custom height for the input field.}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one).}
}
\description{
Create a colour picker htmlwidget. This is not terribly useful right now
since you can use the more powerful \code{\link[colourpicker]{colourInput}}
in Shiny apps and Rmarkdown documents, but this gives you an htmlwidget
version of that colour picker.
}
\examples{
colourWidget()
colourWidget("red", palette = "limited", allowedCols = c("yellow", "red", "#123ABC"))

}

