% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_sequential.R
\name{scale_colour_binned_sequential}
\alias{scale_colour_binned_sequential}
\alias{scale_color_binned_sequential}
\alias{scale_fill_binned_sequential}
\title{HCL-Based Binned Sequential Color Scales for ggplot2}
\usage{
scale_colour_binned_sequential(
  palette = NULL,
  c1 = NULL,
  c2 = NULL,
  cmax = NULL,
  l1 = NULL,
  l2 = NULL,
  h1 = NULL,
  h2 = NULL,
  p1 = NULL,
  p2 = NULL,
  alpha = 1,
  rev = TRUE,
  begin = 0,
  end = 1,
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour",
  n_interp = 11,
  ...
)

scale_color_binned_sequential(
  palette = NULL,
  c1 = NULL,
  c2 = NULL,
  cmax = NULL,
  l1 = NULL,
  l2 = NULL,
  h1 = NULL,
  h2 = NULL,
  p1 = NULL,
  p2 = NULL,
  alpha = 1,
  rev = TRUE,
  begin = 0,
  end = 1,
  na.value = "grey50",
  guide = "coloursteps",
  aesthetics = "colour",
  n_interp = 11,
  ...
)

scale_fill_binned_sequential(..., aesthetics = "fill")
}
\arguments{
\item{palette}{The name of the palette to be used. Run \code{hcl_palettes(type = "sequential")} for available options.}

\item{c1}{Beginning chroma value.}

\item{c2}{Ending chroma value.}

\item{cmax}{Maximum chroma value.}

\item{l1}{Beginning luminance value.}

\item{l2}{Ending luminance value.}

\item{h1}{Beginning hue value.}

\item{h2}{Ending hue value. If set to \code{NA}, generates a single-hue scale.}

\item{p1}{Control parameter determining how chroma should vary (1 = linear, 2 = quadratic, etc.).}

\item{p2}{Control parameter determining how luminance should vary (1 = linear, 2 = quadratic, etc.).}

\item{alpha}{Numeric vector of values in the range \code{[0, 1]} for alpha transparency channel (0 means transparent and 1 means opaque).}

\item{rev}{If \code{TRUE} (default), reverses the order of the colors in the color scale (compared to \code{\link{sequential_hcl}}).}

\item{begin}{Number in the range of \code{[0, 1]} indicating to which point in the color scale the smallest data value should be mapped.}

\item{end}{Number in the range of \code{[0, 1]} indicating to which point in the color scale the largest data value should be mapped.}

\item{na.value}{Color to be used for missing data points.}

\item{guide}{Type of legend. Use \code{"coloursteps"} for color bar with discrete steps.}

\item{aesthetics}{The ggplot2 aesthetics to which this scale should be applied.}

\item{n_interp}{Number of discrete colors that should be used to interpolate the binned color scale. 11 will work fine in most cases.}

\item{...}{common binned scale parameters: `name`, `breaks`, `labels`, and `limits`. See
\code{\link[ggplot2]{binned_scale}} for more details.}
}
\description{
Binned ggplot2 color scales using the color palettes generated by \code{\link{sequential_hcl}}.
}
\details{
If both a valid palette name and palette parameters are provided then the provided palette parameters overwrite the parameters in the
named palette. This enables easy customization of named palettes.

Compared to \code{\link{sequential_hcl}} the ordering of the colors in the sequential ggplot2 scale
are reversed by default (i.e., \code{rev = TRUE}) to be more consistent with ggplot2's own scales such as
\code{\link[ggplot2]{scale_color_fermenter}}. For most named palettes this leads to darker and more
colorful colors for larger values on the scale. This is typically the better default on light/white
backgrounds.
}
\examples{
library("ggplot2")

# volcano plot
df <- data.frame(height = c(volcano), x = c(row(volcano)), y = c(col(volcano)))
ggplot(df, aes(x, y, fill = height)) + 
  geom_raster() + scale_fill_binned_sequential(palette = "Terrain", rev = FALSE) +
  coord_fixed(expand = FALSE)
}
