% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{roi_show}
\alias{roi_show}
\title{Show the selected regions of interest}
\usage{
roi_show(img, ind = c(1, 2))
}
\arguments{
\item{img}{A \code{\link[imager]{cimg}} object or a \code{list} of multiple
images such as the one returned from \code{\link{roi_select}}}

\item{ind}{A \code{numeric} object of length two. For the channel indexes.
or a \code{list} of similar vectors for each of \code{img} items.}
}
\description{
Show/highlight the selected regions of interest on different image channels
}
\details{
calling this function with \code{img} object which is returned from
\code{\link{roi_select}} returns four different plots. The original image, a
low resolution representation of the selected regions of interest and the
two channels indicated through \code{ind} highlighted.
}
\examples{
# load images
fl <- system.file('extdata', 'Image0001_.jpg', package = 'colocr')
img <- image_load(fl)

# choose and show ROI
oldpar <- par()
par(mfrow=c(2,2))

roi_select(img, threshold = 90) \%>\%
  roi_show()

par(oldpar)

}
