% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coi5p.r
\name{coi5p}
\alias{coi5p}
\title{Build a coi5p object from a DNA sequence string.}
\usage{
coi5p(x = character(), name = character())
}
\arguments{
\item{x}{A nucleotide string.
Valid characters within the nucleotide string are: "a", "t", "g", "c", "-" and "n".
coil treats both '-' and 'n' characters as placeholder nucleotides when comparing to the PHMM.
The nucleotide string can be input as upper case, but will be automatically converted to lower case.}

\item{name}{An optional character string that serves as the identifier for the sequence.}
}
\value{
An object of class \code{"coi5p"}
}
\description{
Build a coi5p object from a DNA sequence string.
}
\examples{
#build an unnamed coi5p object
dat = coi5p(example_nt_string)
#build a named coi5p sequence
dat = coi5p(example_nt_string, name = "example_seq1")
#available components in the coi5p object:
dat$raw
dat$name
}
