% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_change_and_difference.R
\name{multivariate_change}
\alias{multivariate_change}
\title{Using dissimilarity-based measures to calculate changes in composition
  and dispersion}
\usage{
multivariate_change(df, time.var, species.var, abundance.var,
  replicate.var, treatment.var = NULL, reference.time = NULL)
}
\arguments{
\item{df}{A data frame containing time, species, abundance and replicate
columns and an optional column of treatment.}

\item{time.var}{The name of the time column.}

\item{species.var}{The name of the species column.}

\item{abundance.var}{The name of the abundance column.}

\item{replicate.var}{The name of the replicate column. Replicate identifiers
must be unique within the dataset and cannot be nested within treatments or
blocks.}

\item{treatment.var}{The name of the optional treatment column.}

\item{reference.time}{The name of the optional time point that all other time
points should be compared to (e.g. the first year of data). If not
specified, each comparison is between consecutive time points (the first
and second year, second and third year, etc.)}
}
\value{
The multivariate_change function returns a data frame with the
  following attributes:
\itemize{
 \item{time.var: }{A column with the specified time.var and a second column,
 with '2' appended to the name. Time is subtracted from time2 for dispersion
 change.}
 \item{composition_change: }{A numeric column that is the distance
 between the centroids of two time points, or NA if a real distance
 could not be calculated.}
 \item{dispersion_change: }{A numeric column that is the difference in the
 average dispersion of the replicates around the centroid for the two time
 periods. A negative value indicates replicates are converging over time
 (there is less dispersion at time period 2 than time period 1) and a
 positive value indicates replicates are diverging over time (there is more
 dispersion at time period 2 than time period 1.}
 \item{treatment.var: }{A column that has same name and type as the
 treatment.var column, if treatment.var is specified.}
}
}
\description{
Calculates the changes in composition and dispersion based off a
  Bray-Curtis dissimilarity matrix. Composition change is the pairwise
  distance between centroids of compared time periods and ranges from 0-1,
  where identical communities give 0 and completely different
  communities give 1. Dispersion change is the difference between time periods in
  the dispersion of replicates, i.e. the average distance between a replicate
  and its centroid.
}
\examples{
data(pplots)
# With treatment
multivariate_change(pplots,
                    time.var="year",
                    replicate.var = "plot",
                    treatment.var = "treatment",
                    species.var = "species",
                    abundance.var = "relative_cover")
# In each year there are 6 replicates and there are 4 years of data for 3
# time comparisons, thus 24 total observations in each treatment.

# With treatment and reference year
multivariate_change(pplots,
                    time.var="year",
                    replicate.var = "plot",
                    treatment.var = "treatment",
                    species.var = "species",
                    abundance.var = "relative_cover",
                    reference.time = 2002)
# In each year there are 6 replicates and there are 4 years of data for 3
# time comparisons, thus 24 total observations in each treatment.

# Without treatment
df <- subset(pplots, treatment == "N1P0")
multivariate_change(df,
                    time.var="year",
                    replicate.var = "plot",
                    species.var = "species",
                    abundance.var = "relative_cover")
# In each year there are 6 replicates and there are 4 years of data for 3
# time comparisons, thus 24 total observations.

}
\references{
Avolio et al. 2015; Avolio et al. Submitted, Marti Anderson et al. 2006.
}
