% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoForecast.R
\name{cocoForecast}
\alias{cocoForecast}
\title{One-Step Ahead Forecast Distribution}
\usage{
cocoForecast(
  coco,
  max = NULL,
  epsilon = 1e-05,
  xcast = NULL,
  decimals = 4,
  julia = FALSE
)
}
\arguments{
\item{coco}{An object of class coco}

\item{max}{The maximum number of the forecast support for the plot. If NULL all values for which the cumulative distribution function is below 1- epsilon are used for the plot.}

\item{epsilon}{If max is NULL, epsilon determines the range of the support that is used by subsequent automatic plotting using R's plot() function.}

\item{xcast}{A vector of covariate values for forecasting}

\item{decimals}{Number of decimal places for the forecast probabilities}

\item{julia}{if TRUE, the estimate is predicted with Julia.}
}
\value{
an object of class cocoBoot. It contains the the probability mass, mode,
and median of the forecast.
}
\description{
Computes the one-step ahead forecast distribution for the models included in the coconots package.
}
\details{
Returns forecasts for each mass point of the one-step ahead
distribution for the fitted model. The exact predictive distributions for
the models included here are provided in Jung and Tremayne (2011), maximum
likelihood estimates replace the true model parameters. Out-of-sample values
for covariates can be provided, if necessary.

Point forecasts are provided by returning the median and the mode of the predictive distribution.
}
\examples{
lambda <- 1
alpha <- 0.4
set.seed(12345)
data <- cocoSim(order = 1, type = "Poisson", par = c(lambda, alpha), length = 100)
#julia_installed = TRUE ensures that the fit object
#is compatible with the julia cocoForecast implementation 
fit <- cocoReg(order = 1, type = "Poisson", data = data)

#median, mode, and density forecasts - R implementation
forecast_r <- cocoForecast(fit)
}
