% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvnormcanon.R
\name{rmvnormcanon}
\alias{rmvnormcanon}
\title{Draw random vectors from multivariate Gaussian in canonical form}
\usage{
rmvnormcanon(n, b, P)
}
\arguments{
\item{n}{Number of draws}

\item{b}{b parameter}

\item{P}{Precision matrix}
}
\value{
matrix with n columns, vector if n=1
}
\description{
Draw random vectors from multivariate Gaussian in canonical form
}
\examples{
P<-matrix(c(1,.5,.5,1),ncol=2)
b=c(2,0)
# expected value and covariance matrix
Sigma = solve(P)
mu = b\%*\%Sigma
# sample
x<-rmvnormcanon(1000,b,P)
mu.hat=apply(x,1,mean)
print(mu.hat-mu)
Sigma.hat=var(t(x))
print(Sigma.hat-Sigma)

}
