% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossClusterMap.R
\name{crossClusterMap}
\alias{crossClusterMap}
\title{Cross-Cluster Mapping Between Concept Maps}
\usage{
crossClusterMap(conceptMap1, conceptMap2)
}
\arguments{
\item{conceptMap1}{An object of class \code{"conceptMap"} representing the first concept map.}

\item{conceptMap2}{An object of class \code{"conceptMap"} representing the second concept map.}
}
\value{
The function does not return a value but generates a \code{ggplot2} visualization.
}
\description{
This function compares two concept maps by aligning their clustering results
and visualizing the correspondence between clusters. It identifies matches
between clusters from the two maps and highlights differences visually.
}
\details{
The function aligns clusters between two concept maps using an optimal matching
algorithm. It first creates a matching matrix based on the overlap between clusters
in the two maps. Then, it uses the Hungarian algorithm (via the \code{solve_LSAP} function
from the \code{clue} package) to find an optimal alignment of clusters.

The output is a plot that shows the alignment of clusters from the two concept maps,
with connecting lines colored to indicate matches or mismatches. Statements not
clustered in both maps are highlighted in grey.
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.90, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Subject sorter cluster 1 to concept mapping using default "network" method
myCMAnalysis1 <- conceptMapping(myCMDataBySorters[[1]])

# Subject sorter cluster 3 to concept mapping using default "network" method
myCMAnalysis3 <- conceptMapping(myCMDataBySorters[[3]])

# Visualise comparison of results of two sorter clusters
crossClusterMap(myCMAnalysis1, myCMAnalysis3)

}
\seealso{
\code{\link[clue]{solve_LSAP}}, \code{\link[ggplot2]{ggplot}}
}
