% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions_Rcpp.R
\name{cut_ratio}
\alias{cut_ratio}
\title{Cut Ratio}
\usage{
cut_ratio(g, com)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object). If the edges have a "weight"
attribute, those will be used as weights.}

\item{com}{community membership integer vector. Each element corresponds to a vertex.}
}
\value{
Numeric vector with the cut ratio of each community.
}
\description{
The cut ratio of a graph's community is the total edge weight connecting the community
to the rest of the graph divided by number of unordered pairs of vertices such that one
belongs to the community and the other does not.
}
\examples{
data(karate, package="igraphdata")
cut_ratio(karate, membership(cluster_louvain(karate)))
}
\seealso{
Other cluster scoring functions: 
\code{\link{FOMD}()},
\code{\link{average_degree}()},
\code{\link{average_odf}()},
\code{\link{conductance}()},
\code{\link{coverage}()},
\code{\link{density_ratio}()},
\code{\link{edges_inside}()},
\code{\link{expansion}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{scoring_functions}()},
\code{\link{weighted_clustering_coefficient}()},
\code{\link{weighted_transitivity}()}
}
\concept{cluster scoring functions}
