/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    @Override
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        if (putMetricDataRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricDataRequest> request = new DefaultRequest<PutMetricDataRequest>(putMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        if (putMetricDataRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricDataRequest.getNamespace()));
        }
        List<MetricDatum> metricDataList = putMetricDataRequest.getMetricData();
        int metricDataListIndex = 1;
        for (MetricDatum metricDataListValue : metricDataList) {
            MetricDatum metricDatumMember = metricDataListValue;
            if (metricDatumMember != null) {
                StatisticSet statisticSetStatisticValues;
                if (metricDatumMember.getMetricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringUtils.fromString(metricDatumMember.getMetricName()));
                }
                List<Dimension> dimensionsList = metricDatumMember.getDimensions();
                int dimensionsListIndex = 1;
                for (Dimension dimensionsListValue : dimensionsList) {
                    Dimension dimensionMember = dimensionsListValue;
                    if (dimensionMember != null) {
                        if (dimensionMember.getName() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionMember.getName()));
                        }
                        if (dimensionMember.getValue() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionMember.getValue()));
                        }
                    }
                    ++dimensionsListIndex;
                }
                if (metricDatumMember.getTimestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringUtils.fromDate(metricDatumMember.getTimestamp()));
                }
                if (metricDatumMember.getValue() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringUtils.fromDouble(metricDatumMember.getValue()));
                }
                if ((statisticSetStatisticValues = metricDatumMember.getStatisticValues()) != null) {
                    if (statisticSetStatisticValues.getSampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringUtils.fromDouble(statisticSetStatisticValues.getSampleCount()));
                    }
                    if (statisticSetStatisticValues.getSum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringUtils.fromDouble(statisticSetStatisticValues.getSum()));
                    }
                    if (statisticSetStatisticValues.getMinimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringUtils.fromDouble(statisticSetStatisticValues.getMinimum()));
                    }
                    if (statisticSetStatisticValues.getMaximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringUtils.fromDouble(statisticSetStatisticValues.getMaximum()));
                    }
                }
                if (metricDatumMember.getUnit() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringUtils.fromString(metricDatumMember.getUnit()));
                }
            }
            ++metricDataListIndex;
        }
        return request;
    }
}

