/*
 * Decompiled with CFR 0.152.
 */
package cloudrmpi;

import com.amazonaws.services.ec2.model.Region;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.networkspec.AmiChoiceU;
import com.norbl.cbp.ppe.gui.networkspec.NSGFrameU;
import com.norbl.cbp.ppe.gui.networkspec.NetworkSpecGui;
import com.norbl.cbp.ppe.ompi.OmpiPPEManager;
import com.norbl.util.ArgvUtil;
import com.norbl.util.StringUtil;
import com.norbl.util.gui.GuiUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import rreval.AppCmd;
import rreval.ConnectionR;
import rreval.Message;
import rreval.MessageWrangler;
import rreval.RReaderEOFException;
import rreval.Verbose;

public class ROmpiPPEManager
extends OmpiPPEManager {
    public static final Class R_AMI_CHOICE_CLASS = AmiChoiceU.class;
    public static final Class R_NSG_FRAME_CLASS = NSGFrameU.class;
    public static String PORT_LABEL = "ppeManagerPort";
    public static int PORT_DEFAULT = 4461;
    public static boolean VERBOSE_DEFAULT = true;
    int cmdPort;
    ServerSocket serverSocket;
    boolean keepRunning;
    List<CmdHandler> cmdHandlers = new ArrayList<CmdHandler>();

    public ROmpiPPEManager(String[] argv, String amiGroup, Region ec2Region) throws Exception {
        super(argv, amiGroup, ec2Region);
        this.cmdPort = ArgvUtil.getIntVal((String[])argv, (String)PORT_LABEL, (int)PORT_DEFAULT);
        String verb = ArgvUtil.getVal((String[])argv, (String)"verbose");
        Verbose.verbose = verb == null ? VERBOSE_DEFAULT : (verb.equals("true") ? true : (verb.equals("false") ? false : VERBOSE_DEFAULT));
    }

    protected NetworkSpec getFullySpecifiedNetworkSpec(String networkName) {
        try {
            NetworkSpecGui nsg = new NetworkSpecGui((PPEManager)this, R_AMI_CHOICE_CLASS, R_NSG_FRAME_CLASS, networkName);
            if (nsg.fillSpec()) {
                return nsg.choicesToNetworkSpec();
            }
            return null;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage((Throwable)xxx);
            return null;
        }
    }

    protected String getAboutAppTitle() {
        return "cloudRmpi";
    }

    protected String getAboutAppVersion() {
        return "<html>Version 1.1<br><br><br> &copy; 2012, Barnet Wagman<br>Northbranchlogic, Inc.<html>";
    }

    public void startCmdHandler() {
        this.socketServer();
    }

    void socketServer() {
        try {
            this.serverSocket = new ServerSocket(this.cmdPort);
            this.keepRunning = true;
            while (this.keepRunning) {
                Socket s = this.serverSocket.accept();
                CmdHandler h = new CmdHandler(s);
                this.cmdHandlers.add(h);
                new Thread(h).start();
                Verbose.show((String)"Launched new CmdHandler");
            }
        }
        catch (IOException iox) {
            System.out.println(StringUtil.toString((Throwable)iox));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Verbose.show((String)"Shutting down ROmpiPPEManager");
        try {
            this.keepRunning = false;
            this.serverSocket.close();
            for (CmdHandler h : this.cmdHandlers) {
                h.closeCmdHandler();
            }
        }
        catch (Exception x) {
            System.err.println(StringUtil.toString((Throwable)x));
        }
        finally {
            System.exit(0);
        }
    }

    public void ppeManagerExiting() {
        Verbose.show((String)"The ompi-ppe manager has been closed.");
        this.shutdown();
    }

    String getNetworkNames() {
        List nis = NiM.getNetworks();
        if (nis.size() < 1) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (NetworkInfo ni : nis) {
            s.append(ni.getNetworkName());
            s.append(" ");
        }
        return s.toString().trim();
    }

    String getNetworkIDs() {
        List nis = NiM.getNetworks();
        if (nis.size() < 1) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (NetworkInfo ni : nis) {
            s.append(ni.getNetworkID());
            s.append(" ");
        }
        return s.toString().trim();
    }

    NetworkInfo getNi(AppCmd cmd) {
        NetworkInfo ni;
        NetworkInfo ni2;
        String nID = cmd.getVal(Arg.networkID.toString());
        if (nID != null && nID.length() > 0 && (ni2 = NiM.getForID((String)nID)) != null) {
            return ni2;
        }
        String nNm = cmd.getVal(Arg.networkName.toString());
        if (nNm != null && nNm.length() > 0 && (ni = NiM.getForName((String)nNm)) != null) {
            return ni;
        }
        return null;
    }

    String getNetworkStateDescription(AppCmd cmd) {
        NetworkInfo ni = this.getNi(cmd);
        if (ni != null) {
            return ni.getStateDescription();
        }
        return "";
    }

    String getMasterNodeURL(AppCmd cmd) {
        NetworkInfo ni = this.getNi(cmd);
        if (ni != null) {
            return ni.getMastersPublicDnsName();
        }
        return "";
    }

    String getNActiveInstances(AppCmd cmd) {
        NetworkInfo ni = this.getNi(cmd);
        if (ni != null) {
            return Integer.toString(ni.getNActiveInstances());
        }
        return "0";
    }

    String getPemFile() {
        return ROmpiPPEManager.paramsEc2.rsaKeyPairFile.getPath();
    }

    String terminateNetwork(AppCmd cmd) {
        NetworkInfo ni = this.getNi(cmd);
        if (ni == null) {
            String networkName = cmd.getVal(Arg.networkName.toString());
            String networkID = cmd.getVal(Arg.networkID.toString());
            String s = "Unable to find network";
            if (networkName != null) {
                s = s + " " + networkName;
            }
            if (networkID != null) {
                s = s + " " + networkID;
            }
            return s;
        }
        this.terminateInstances(ni.getNetworkID());
        return "Terminating all ec2 instances in network " + ni.getNetworkName();
    }

    protected String getAmiWebpageUrl() {
        return "https://s3.amazonaws.com/norbl/Machine_images_cloudrmpi.html";
    }

    protected String getManualWebpageUrl() {
        return "http://norbl.com/cloudrmpi/cloudRmpi_Manual.html";
    }

    class CmdHandler
    extends MessageWrangler
    implements Runnable {
        Socket socket;
        boolean keepRunning;

        CmdHandler(Socket s) {
            this.socket = s;
        }

        @Override
        public void run() {
            try {
                this.conR = new ConnectionR(this.socket);
            }
            catch (Exception x) {
                System.out.println(StringUtil.toString((Throwable)x));
                System.exit(0);
            }
            this.keepRunning = true;
            Verbose.show((String)"... ready to start receiving messages.");
            while (this.keepRunning) {
                Message m;
                block18: {
                    m = null;
                    try {
                        m = this.conR.readMessage();
                        Verbose.show((String)("Received message=" + m));
                    }
                    catch (Exception xx) {
                        if (!(xx instanceof RReaderEOFException)) break block18;
                        Verbose.show((String)"Closing CmdHandler", (Exception)xx);
                        this.closeCmdHandler();
                        return;
                    }
                }
                try {
                    if (m == null) continue;
                    AppCmd ac = new AppCmd(m.obj);
                    Verbose.show((String)("ClientCmdHandler app cmd=" + ac.toString()));
                    Cmd c = Cmd.valueOf(ac.getCmdName());
                    switch (c) {
                        case getNetworkNames: {
                            this.sendMessageToR(ROmpiPPEManager.this.getNetworkNames());
                            break;
                        }
                        case getNetworkIDs: {
                            this.sendMessageToR(ROmpiPPEManager.this.getNetworkIDs());
                            break;
                        }
                        case getNetworkStateDescription: {
                            this.sendMessageToR(ROmpiPPEManager.this.getNetworkStateDescription(ac));
                            break;
                        }
                        case getMasterNodeURL: {
                            this.sendMessageToR(ROmpiPPEManager.this.getMasterNodeURL(ac));
                            break;
                        }
                        case getNActiveInstances: {
                            this.sendMessageToR(ROmpiPPEManager.this.getNActiveInstances(ac));
                            break;
                        }
                        case getPemFile: {
                            this.sendMessageToR(ROmpiPPEManager.this.getPemFile());
                            break;
                        }
                        case terminateNetwork: {
                            this.sendMessageToR(ROmpiPPEManager.this.terminateNetwork(ac));
                            break;
                        }
                        case disconnect: {
                            this.sendMessageToR("Disconnecting from ROmpiPPEManager");
                            this.closeCmdHandler();
                            break;
                        }
                        case shutdown: {
                            this.sendMessageToR("Shutting down ROmpiPPEManager");
                            ROmpiPPEManager.this.shutdown();
                            break;
                        }
                    }
                }
                catch (Exception x) {
                    Verbose.show((String)"ClientCmdHandler.handleCmd(): ", (Exception)x);
                    this.sendErrMToR("ClientCmdHandler.handleCmd()", x);
                }
            }
        }

        public void closeCmdHandler() {
            this.keepRunning = false;
            if (this.conR != null) {
                this.conR.close();
                this.conR = null;
            }
        }
    }

    private static enum Arg {
        networkID,
        networkName;

    }

    private static enum Cmd {
        getNetworkNames,
        getNetworkIDs,
        getNetworkStateDescription,
        getMasterNodeURL,
        getNActiveInstances,
        getPemFile,
        terminateNetwork,
        disconnect,
        shutdown;

    }
}

