/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.services.ec2.model.InstanceType;
import com.norbl.util.StringUtil;
import com.norbl.util.aws.S3Access;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.gui.TableModelRowable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class Ec2InstanceType
implements TableModelRowable,
Serializable {
    static final long serialVersionUID = 0L;
    public InstanceType instanceType;
    public VirtualizationType vt;
    public int nCores;
    public double ramGB;
    public boolean clusterSupport;
    public double pricePiph;
    public String description;

    public Ec2InstanceType(InstanceType instanceType, int nCores, double ramGB, boolean clusterSupport, VirtualizationType vt, double pricePiph, String description) {
        this.instanceType = instanceType;
        this.nCores = nCores;
        this.ramGB = ramGB;
        this.clusterSupport = clusterSupport;
        this.vt = vt;
        this.pricePiph = pricePiph;
        this.description = description;
    }

    public String toString() {
        return this.instanceType.toString() + " " + this.vt.toString() + " nCores=" + Integer.toString(this.nCores) + " ramGB=" + StringUtil.f1(this.ramGB) + " cluster support=" + Boolean.toString(this.clusterSupport) + " price/instance/hr=" + StringUtil.f2(this.pricePiph) + " " + this.description;
    }

    public boolean isPv() {
        return this.vt.equals((Object)VirtualizationType.pv);
    }

    public boolean isHvm() {
        return this.vt.equals((Object)VirtualizationType.hvm);
    }

    public String getDescription() {
        return this.description;
    }

    public static InstanceType getInstanceType(String instanceTypeName) throws IllegalArgumentException {
        return InstanceType.fromValue((String)instanceTypeName);
    }

    public static Ec2InstanceType getEc2InstanceType(List<Ec2InstanceType> eits, InstanceType iType) throws FileNotFoundException, IOException, NullPointerException {
        for (Ec2InstanceType eit : eits) {
            if (!eit.instanceType.equals((Object)iType)) continue;
            return eit;
        }
        return null;
    }

    private static boolean toBoolean(String s) {
        return "yes".equals(s.trim().toLowerCase());
    }

    public static boolean isPv(String s) {
        if (s == null) {
            return false;
        }
        String l = s.trim().toLowerCase();
        return l.equals("pv") || l.equals("paravirtual");
    }

    public static boolean isHvm(String s) {
        if (s == null) {
            return false;
        }
        String l = s.trim().toLowerCase();
        return l.equals("hvm") || l.equals("hardware virtual machine") || l.equals("hardwarevirtualmachine");
    }

    @Override
    public Class getColumnClass(int colIndex) {
        switch (colIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int colIndex) {
        switch (colIndex) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Virtualization type";
            }
            case 2: {
                return "N cores";
            }
            case 3: {
                return "Description";
            }
        }
        return null;
    }

    @Override
    public Object getColumnValue(int colIndex) {
        switch (colIndex) {
            case 0: {
                return this.instanceType != null ? this.instanceType.toString() : "";
            }
            case 1: {
                return this.vt != null ? this.vt.toString() : "";
            }
            case 2: {
                return new Integer(this.nCores);
            }
            case 3: {
                return this.description != null ? this.description : "";
            }
        }
        return null;
    }

    @Override
    public int getNColumns() {
        return 4;
    }

    @Override
    public void setColumnValue(int colIndex, Object value) {
        switch (colIndex) {
            case 0: {
                if (value instanceof String) {
                    String nm = ((String)value).trim();
                    try {
                        this.instanceType = Ec2InstanceType.getInstanceType(nm);
                    }
                    catch (Exception itx) {
                        this.warning("Undefined instance type: " + nm);
                        this.instanceType = null;
                    }
                    break;
                }
                this.warning(" Illegal " + this.getColumnName(colIndex) + "; it must be a string.");
                break;
            }
            case 1: {
                VirtualizationType nvt = this.getVT(value);
                if (nvt != null) {
                    this.vt = nvt;
                    break;
                }
                this.warning("Undefined virtualization type=" + value + "; it must be pv or hvm");
                break;
            }
            case 2: {
                int nc = this.getNC(value);
                if (nc > 0) {
                    this.nCores = nc;
                    break;
                }
                this.warning("N cores must be > 0");
                break;
            }
            case 3: {
                if (value instanceof String) {
                    this.description = (String)value;
                    break;
                }
                this.warning("Bad desciption: object has class " + (value == null ? "null" : value.getClass().getName()));
                break;
            }
        }
    }

    public boolean isFullySpecified() {
        return this.instanceType != null && this.vt != null && this.nCores > 0;
    }

    private VirtualizationType getVT(Object value) {
        try {
            if (!(value instanceof String)) {
                return null;
            }
            return VirtualizationType.valueOf(((String)value).trim());
        }
        catch (Exception xxx) {
            return null;
        }
    }

    private int getNC(Object val) {
        try {
            Integer iv;
            if (val instanceof Integer) {
                iv = (Integer)val;
            } else if (val instanceof String) {
                iv = Integer.parseInt((String)val);
            } else {
                return 0;
            }
            return iv;
        }
        catch (Exception x) {
            return 0;
        }
    }

    private void warning(String message) {
        GuiUtil.warning(new String[]{message}, "Entry error");
    }

    public static List<Ec2InstanceType> getInstanceTypes() throws Exception {
        S3Access s3a = new S3Access();
        return (List)s3a.getObject("norbl-ppe-info", "instance-types");
    }

    public static enum VirtualizationType {
        pv,
        hvm;

    }
}

