/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import com.norbl.util.ArgvUtil;
import com.norbl.util.StringUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import rreval.ConnectionJ;
import rreval.ConnectionR;
import rreval.ServerMessageHandler;
import rreval.Verbose;

public class RReServerApp {
    public static final int SERVER_PORT_RJ_DEFAULT = 4463;
    public static final int SERVER_PORT_JJ_DEFAULT = 4464;
    int portRJ;
    int portJJ;
    boolean keepRunning;
    ServerMessageHandler handler;
    boolean connectedToClient;

    public RReServerApp(int portRJ, int portJJ) {
        this.portRJ = portRJ;
        this.portJJ = portJJ;
    }

    public void launch() {
        try {
            this.connectedToClient = false;
            ServerSocket serverRJ = new ServerSocket(this.portRJ);
            Verbose.show("... waiting for RReServer to connect");
            Socket socketR = serverRJ.accept();
            ConnectionR conR = new ConnectionR(socketR);
            Verbose.show("RReServer has connected.");
            ServerSocket serverJJ = new ServerSocket(this.portJJ);
            while (true) {
                Verbose.show("... waiting for the client app to connect.");
                Socket s = serverJJ.accept();
                Verbose.show("... client has socket, waiting for connection.");
                ConnectionJ conJ = new ConnectionJ(s, ConnectionJ.HostType.server);
                Verbose.show("A client app has connected.");
                if (!this.connectedToClient) {
                    this.handler = new ServerMessageHandler(this, conR, conJ, true);
                    new Thread(this.handler).start();
                    continue;
                }
                ServerMessageHandler h = new ServerMessageHandler(this, conR, conJ, false);
                new Thread(h).start();
            }
        }
        catch (Exception iox) {
            Verbose.show("Terminal exception", iox);
            System.exit(0);
            return;
        }
    }

    public void closeConnections() throws IOException {
        this.handler.close();
    }

    public void shutdown() {
        this.keepRunning = false;
        System.exit(0);
    }

    public static void main(String[] argv) {
        int portR = ArgvUtil.getIntVal((String[])argv, (String)"portRJ", (int)4463);
        int portJ = ArgvUtil.getIntVal((String[])argv, (String)"portJ", (int)4464);
        Verbose.verbose = Boolean.parseBoolean(ArgvUtil.getVal((String[])argv, (String)"verbose", (String)"true"));
        Verbose.show("Launching RReServerApp portR=" + portR + " portJ=" + portJ);
        RReServerApp app = new RReServerApp(portR, portJ);
        app.launch();
    }

    class ServerThread
    implements Runnable {
        int port;
        Socket socket;
        boolean connected;

        ServerThread(int port) {
            this.port = port;
            this.connected = false;
        }

        @Override
        public void run() {
            try {
                ServerSocket server = new ServerSocket(this.port);
                this.socket = server.accept();
                this.connected = true;
                Verbose.show("Connected on port=" + this.port);
            }
            catch (Exception xx) {
                System.err.println(StringUtil.getExceptionMessage((Throwable)xx) + "\n\n" + StringUtil.exceptionStackToString((Throwable)xx));
                System.exit(0);
            }
        }
    }
}

