/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import com.norbl.util.StringUtil;
import java.net.Socket;
import rreval.ClientCmdHandler;
import rreval.ConduitClientSide;
import rreval.ConnectionJ;
import rreval.ConnectionR;
import rreval.Message;
import rreval.MessageType;
import rreval.MessageWrangler;
import rreval.RReClientApp;
import rreval.RReaderEOFException;
import rreval.Verbose;

public class ClientMessageHandler
extends MessageWrangler
implements Runnable {
    protected Socket socketR;
    protected RReClientApp parentApp;
    protected ClientCmdHandler cmdHandler;
    protected ConduitClientSide conduit;
    protected boolean keepRunning;

    public ClientMessageHandler(Socket socketR, RReClientApp parentApp) {
        this.socketR = socketR;
        this.parentApp = parentApp;
    }

    protected ClientMessageHandler() {
    }

    @Override
    public void run() {
        try {
            this.keepRunning = true;
            this.setConR(new ConnectionR(this.socketR));
            this.cmdHandler = new ClientCmdHandler(this.conR, this);
            this.conduit = new ConduitClientSide(this.conR, this);
            Verbose.show("... ClientMessageHandler.run()  ready to start reading messages.");
            while (this.keepRunning) {
                Message m;
                block9: {
                    m = null;
                    try {
                        m = this.conR.readMessage();
                    }
                    catch (Exception xx) {
                        if (!(xx instanceof RReaderEOFException)) break block9;
                        Verbose.show("Closing ClientMessageHandler", xx);
                        this.closeHandler();
                        return;
                    }
                }
                if (m == null) continue;
                Verbose.show("Got message=" + m);
                if (m.isAppCmd()) {
                    Verbose.show("    is app cmd");
                    this.cmdHandler.handleCmd(m);
                    continue;
                }
                if (m.isMessageToR() || m.isRReServerCmd()) {
                    Verbose.show("    is r message");
                    this.conduit.handleRMessage(m);
                    continue;
                }
                Verbose.show("    bad message type");
                try {
                    this.conR.writeMessage(this.createWrongTypeErrorMessage(m));
                }
                catch (Exception z) {
                    System.err.println(StringUtil.toString((Throwable)z));
                }
            }
        }
        catch (Exception iox) {
            Verbose.show("ClientMessageHandler.run()", iox);
            throw new RuntimeException(iox);
        }
    }

    public void closeHandler() {
        Verbose.show("ClientMessageHandler.closeHandler()");
        this.keepRunning = false;
        if (this.conR != null) {
            this.conR.close();
            this.conR = null;
        }
        if (this.conJ != null) {
            this.conJ.close();
            this.conJ = null;
        }
        this.parentApp.remove(this);
        Verbose.show("ClientMessageHandler.closeHandler() n handlers after remove=" + this.parentApp.getNHandlers());
    }

    public void shutdown() {
        Verbose.show("ClientMessageHandler.shutdown() n handlers=" + this.parentApp.getNHandlers());
        this.closeHandler();
        Verbose.show("ClientMessageHandler.shutdown() handler closed, n handlers=" + this.parentApp.getNHandlers());
        if (this.parentApp.getNHandlers() < 1) {
            this.parentApp.shutdown();
        }
    }

    public void closeAllConnections() {
        try {
            this.cmdHandler.closeConnection(false);
            this.closeHandler();
        }
        catch (Exception xxx) {
            System.err.println(StringUtil.toString((Throwable)xxx));
        }
    }

    public void setConJs(ConnectionJ conJ) {
        this.setConJ(conJ);
        if (this.cmdHandler != null) {
            this.cmdHandler.setConJ(conJ);
        }
        if (this.conduit != null) {
            this.conduit.setConJ(conJ);
        }
    }

    boolean isConnectedToConduit() {
        return this.conJ != null;
    }

    boolean isConnectedToClient() {
        return this.conR != null;
    }

    Message createErrorMessage(String mess) {
        return new Message(MessageType.er, mess);
    }
}

