/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.norbl.cbp.ppe.InstanceStatus;
import com.norbl.util.gui.GuiUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class EbsVolumeWrangler {
    AmazonEC2Client aec;
    public List<Volume> volumes;
    VolumeTableModel vtm;

    public EbsVolumeWrangler(AmazonEC2Client aec) {
        this.aec = aec;
    }

    public void retrieveVolumeInfo() {
        this.volumes = this.aec.describeVolumes().getVolumes();
        if (this.vtm != null) {
            this.vtm.fireTableDataChanged();
        }
    }

    public boolean attachVolume(String instanceID, String volumeID, String device) {
        try {
            AttachVolumeRequest req = new AttachVolumeRequest(volumeID, instanceID, device);
            this.aec.attachVolume(req);
            return true;
        }
        catch (Exception ix) {
            GuiUtil.exceptionMessageOnly(ix);
            return false;
        }
    }

    public boolean detachVolume(String volumeID) {
        try {
            DetachVolumeRequest req = new DetachVolumeRequest(volumeID);
            this.aec.detachVolume(req);
            return true;
        }
        catch (Exception ix) {
            GuiUtil.exceptionMessageOnly(ix);
            return false;
        }
    }

    public List<Volume> getDetachableVolumes(String availabilityZone) {
        ArrayList<Volume> vs = new ArrayList<Volume>();
        if (this.volumes == null) {
            return vs;
        }
        for (Volume v : this.volumes) {
            if (!v.getAvailabilityZone().equals(availabilityZone) || !this.isInUse(v) || this.isRootVolume(v)) continue;
            vs.add(v);
        }
        return vs;
    }

    public List<Volume> getAttachableVolumes(String availabilityZone) {
        ArrayList<Volume> vs = new ArrayList<Volume>();
        if (this.volumes == null) {
            return vs;
        }
        for (Volume v : this.volumes) {
            if (!v.getAvailabilityZone().equals(availabilityZone) || !this.isAvailable(v)) continue;
            vs.add(v);
        }
        return vs;
    }

    public String getDevice(Volume v) {
        if (!this.isInUse(v)) {
            return "";
        }
        List vas = v.getAttachments();
        for (VolumeAttachment va : vas) {
            String d = va.getDevice();
            if (d == null || d.length() <= 0) continue;
            return d;
        }
        return "";
    }

    private boolean isRootVolume(Volume v) {
        if (this.isAvailable(v)) {
            return false;
        }
        List vas = v.getAttachments();
        for (VolumeAttachment va : vas) {
            if (!va.getDevice().startsWith("/dev/sda")) continue;
            return true;
        }
        return false;
    }

    private boolean isInUse(Volume v) {
        return v.getState().equals("in-use");
    }

    private boolean isAvailable(Volume v) {
        return v.getState().equals("available");
    }

    public TableModel getTableModel() {
        if (this.vtm == null) {
            this.vtm = new VolumeTableModel();
        }
        return this.vtm;
    }

    public void createAttachMenu(JMenu parent, InstanceStatus instanceStatus) {
        new Attacher(parent, instanceStatus).go();
    }

    public void createDetachMenu(JMenu parent, InstanceStatus instanceStatus) {
        new Detacher(parent, instanceStatus).go();
    }

    private static String tagsToString(List<Tag> tags) {
        StringBuilder s = new StringBuilder("");
        for (Tag t : tags) {
            s.append(t.getValue() + " ");
        }
        return s.toString().trim();
    }

    private Volume getVolume(String ID) {
        if (this.volumes == null) {
            return null;
        }
        for (Volume v : this.volumes) {
            if (!v.getVolumeId().equals(ID)) continue;
            return v;
        }
        return null;
    }

    String okToAttach(String instanceID, Volume v) {
        String s = (String)JOptionPane.showInputDialog(GuiUtil.getIconFrame(), this.getAttachMessage(instanceID, v), "Attach volume", 2, null, null, "/dev/sdf");
        if (s == null) {
            return null;
        }
        if (s.length() > 2) {
            return s;
        }
        if (GuiUtil.answerIsYes(new String[]{"'" + s + "' is not a valid device name.", " ", "Try again?"}, "Invalid device name")) {
            return this.okToAttach(instanceID, v);
        }
        return null;
    }

    boolean okToDetach(String instanceID, Volume v) {
        int x = JOptionPane.showConfirmDialog(GuiUtil.getIconFrame(), this.getDetachMessage(instanceID, v), "Detach volume", 2);
        return x == 0;
    }

    private String[] getAttachMessage(String instanceID, Volume v) {
        return new String[]{" ", "Attach volume " + v.getVolumeId() + " to instance " + instanceID + "?", " ", "Specify the device below. AWS documentation recommends", "using /dev/sd[f-p].", "  ", "After attaching the volume, you will still need to mount it", "(and create a filesystem, if it is a newly created volume).", "You can launch a simple ssh shell from the instance's popup", "menu to issue these commands or use regular ssh externally.", "  ", "Specify device:", " "};
    }

    private String[] getDetachMessage(String instanceID, Volume v) {
        return new String[]{" ", "Detach volume " + v.getVolumeId() + " from instance " + instanceID + "?", " ", "Be sure that the device has been unmounted before detaching it.", "Note that the device will be umounted and detached when the ", "instance is terminated, so detaching it here is not usually", "necessary.", " ", "Detaching a volume may take a little time (typically 10 to 20", "seconds).  You can use the AWS Management Console to check the", "status of your volumes."};
    }

    class Detacher
    extends Tacher
    implements ActionListener {
        Detacher(JMenuItem parentMi, InstanceStatus instanceStatus) {
            super(parentMi, instanceStatus);
        }

        @Override
        void go() {
            List<Volume> vs = EbsVolumeWrangler.this.getDetachableVolumes(this.az);
            if (vs.size() < 1) {
                JMenuItem mi = new JMenuItem("No detachable volumes in " + this.az);
                mi.setEnabled(true);
                this.parentMi.add(mi);
                return;
            }
            for (Volume v : vs) {
                JMenuItem mi = new JMenuItem();
                mi.setText((v.getVolumeId() + " " + v.getState() + " " + this.az + " " + EbsVolumeWrangler.tagsToString(v.getTags())).trim());
                mi.setActionCommand(v.getVolumeId());
                mi.addActionListener(this);
                mi.setEnabled(v.getState().equals("in-use"));
                this.parentMi.add(mi);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Volume v = EbsVolumeWrangler.this.getVolume(ev.getActionCommand());
            if (v == null) {
                return;
            }
            String instanceID = this.instanceStatus.instance.getInstanceId();
            if (EbsVolumeWrangler.this.okToDetach(instanceID, v)) {
                EbsVolumeWrangler.this.detachVolume(v.getVolumeId());
                EbsVolumeWrangler.this.retrieveVolumeInfo();
            }
        }
    }

    class Attacher
    extends Tacher
    implements ActionListener {
        Attacher(JMenuItem parentMi, InstanceStatus instanceStatus) {
            super(parentMi, instanceStatus);
        }

        @Override
        void go() {
            List<Volume> vs = EbsVolumeWrangler.this.getAttachableVolumes(this.az);
            if (vs.size() < 1) {
                JMenuItem mi = new JMenuItem("No attachable volumes in " + this.az);
                mi.setEnabled(true);
                this.parentMi.add(mi);
                return;
            }
            for (Volume v : vs) {
                JMenuItem mi = new JMenuItem();
                mi.setText((v.getVolumeId() + " " + v.getState() + " " + this.az + " " + EbsVolumeWrangler.tagsToString(v.getTags())).trim());
                mi.setActionCommand(v.getVolumeId());
                mi.addActionListener(this);
                mi.setEnabled(v.getState().equals("available"));
                this.parentMi.add(mi);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Volume v = EbsVolumeWrangler.this.getVolume(ev.getActionCommand());
            if (v == null) {
                return;
            }
            String instanceID = this.instanceStatus.instance.getInstanceId();
            String dev = EbsVolumeWrangler.this.okToAttach(instanceID, v);
            if (dev != null) {
                EbsVolumeWrangler.this.attachVolume(instanceID, v.getVolumeId(), dev);
                EbsVolumeWrangler.this.retrieveVolumeInfo();
            }
        }
    }

    abstract class Tacher {
        String az;
        List<Volume> vs;
        JMenuItem parentMi;
        InstanceStatus instanceStatus;

        Tacher(JMenuItem parentMi, InstanceStatus instanceStatus) {
            this.parentMi = parentMi;
            this.instanceStatus = instanceStatus;
            this.az = instanceStatus.instance.getPlacement().getAvailabilityZone();
        }

        abstract void go();
    }

    public class VolumeTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return Col.values().length;
        }

        @Override
        public String getColumnName(int iCol) {
            return Col.values()[iCol].title;
        }

        @Override
        public int getRowCount() {
            if (EbsVolumeWrangler.this.volumes != null) {
                return EbsVolumeWrangler.this.volumes.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int iRow, int iCol) {
            if (EbsVolumeWrangler.this.volumes == null || EbsVolumeWrangler.this.volumes.size() < 1) {
                return null;
            }
            Volume v = EbsVolumeWrangler.this.volumes.get(iRow);
            Col c = Col.values()[iCol];
            switch (c) {
                case volumeID: {
                    return v.getVolumeId();
                }
                case availabilityZone: {
                    return v.getAvailabilityZone();
                }
                case state: {
                    return v.getState();
                }
                case size: {
                    return v.getSize();
                }
                case createTime: {
                    return v.getCreateTime();
                }
                case mountDevice: {
                    return EbsVolumeWrangler.this.getDevice(v);
                }
                case tags: {
                    return EbsVolumeWrangler.tagsToString(v.getTags()).trim();
                }
            }
            return null;
        }
    }

    static enum Col {
        volumeID("Volume ID"),
        availabilityZone("Availablity zone"),
        state("State"),
        size("Size GB"),
        createTime("Create time"),
        mountDevice("Device"),
        tags("Tags");

        String title;

        private Col(String title) {
            this.title = title;
        }
    }
}

