/*
 * Decompiled with CFR 0.152.
 */
package ppe.ec2;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.InstanceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import nbl.utilj.SysProp;
import ppe.ec2.AmiDescription;
import ppe.ec2.Ec2InstanceType;
import ppe.ec2.IncompatibleInstanceImageException;
import ppe.ec2.NoSuchAmiException;
import ppe.ec2.NoSuchInstanceException;

public class UtilEc2 {
    public static String FILE_SEP = SysProp.file_separator.getVal();

    public static File getMpiEc2Home() {
        String[] jars;
        File hd;
        String hdPath = System.getProperty("ppe_home");
        if (hdPath != null && (hd = new File(hdPath)).exists() && hd.isDirectory()) {
            return hd;
        }
        String cp = SysProp.java_class_path.getVal();
        for (String jar : jars = cp.split(":")) {
            if (!jar.contains("lib" + FILE_SEP + "ppe.jar")) continue;
            return UtilEc2.getHome(new File(jar));
        }
        for (String jar : jars) {
            if (!jar.contains("jars" + FILE_SEP + "ppe.jar")) continue;
            return UtilEc2.getHome(new File(jar));
        }
        for (String jar : jars) {
            if (jar.endsWith("mpi-ec2" + FILE_SEP + "src")) {
                return new File(jar).getParentFile();
            }
            if (!jar.endsWith("ppe_201201" + FILE_SEP + "src")) continue;
            return new File(jar).getParentFile();
        }
        for (String jar : jars) {
            System.out.println(jar);
        }
        throw new RuntimeException("Failed to find mpi-ec2 home.");
    }

    private static File getHome(File jarFile) {
        return jarFile.getParentFile().getParentFile();
    }

    public static void checkInstanceImageCompatibility(InstanceType instanceType, String imageID, AmazonEC2Client ec2) throws FileNotFoundException, IOException, NoSuchInstanceException, NoSuchAmiException, IncompatibleInstanceImageException {
        Ec2InstanceType iType = Ec2InstanceType.getInstanceInfo(instanceType);
        if (iType == null) {
            throw new NoSuchInstanceException("Instance type " + instanceType + " is not listed in config/ec2-instance-types");
        }
        Image ami = AmiDescription.getImageInfo(ec2, imageID);
        if (ami == null) {
            throw new NoSuchAmiException("No ami with ID=" + imageID + " was found.");
        }
        if (iType.isHvm() && !UtilEc2.supportsHvm(imageID, ec2)) {
            throw new IncompatibleInstanceImageException("Instance type=" + iType.instanceType.toString() + " is not compatible with ami=" + ami + "; this instance type requires an hvm image.");
        }
        if (iType.isPv() && !UtilEc2.supportsPv(imageID, ec2)) {
            throw new IncompatibleInstanceImageException("Instance type=" + iType.instanceType.toString() + " is not compatible with ami=" + ami + "; this instance type requires an pv image.");
        }
    }

    static boolean supportsHvm(String ami, AmazonEC2Client ec2) {
        Image img = AmiDescription.getImageInfo(ec2, ami);
        return img.getVirtualizationType().toLowerCase().equals("hvm");
    }

    static boolean supportsPv(String ami, AmazonEC2Client ec2) {
        Image img = AmiDescription.getImageInfo(ec2, ami);
        return img.getVirtualizationType().toLowerCase().equals("paravirtual");
    }

    public static void L(String s) {
        System.out.println(s);
    }

    public static String toCsv(List<String> strs) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strs.size() - 1; ++i) {
            s.append(strs + ", ");
        }
        s.append(strs.get(strs.size() - 1));
        return s.toString();
    }
}

