% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration-helper}
\alias{duration-helper}
\alias{duration_years}
\alias{duration_quarters}
\alias{duration_months}
\alias{duration_weeks}
\alias{duration_days}
\alias{duration_hours}
\alias{duration_minutes}
\alias{duration_seconds}
\alias{duration_milliseconds}
\alias{duration_microseconds}
\alias{duration_nanoseconds}
\title{Construct a duration}
\usage{
duration_years(n = integer())

duration_quarters(n = integer())

duration_months(n = integer())

duration_weeks(n = integer())

duration_days(n = integer())

duration_hours(n = integer())

duration_minutes(n = integer())

duration_seconds(n = integer())

duration_milliseconds(n = integer())

duration_microseconds(n = integer())

duration_nanoseconds(n = integer())
}
\arguments{
\item{n}{\verb{[integer]}

The number of units of time to use when creating the duration.}
}
\value{
A duration of the specified precision.
}
\description{
These helpers construct durations of the specified precision. Durations
represent units of time.

Durations are separated into two categories:

\strong{Calendrical}
\itemize{
\item year
\item quarter
\item month
}

\strong{Chronological}
\itemize{
\item week
\item day
\item hour
\item minute
\item second
\item millisecond
\item microsecond
\item nanosecond
}

Calendrical durations are generally used when manipulating calendar types,
like year-month-day. Chronological durations are generally used when
working with time points, like sys-time or naive-time.
}
\section{Internal Representation}{


Durations are internally represented as an integer number of "ticks" along
with a ratio describing how it converts to a number of seconds. The
following duration ratios are used in clock:
\itemize{
\item \verb{1 year == 31556952 seconds}
\item \verb{1 quarter == 7889238 seconds}
\item \verb{1 month == 2629746 seconds}
\item \verb{1 week == 604800 seconds}
\item \verb{1 day == 86400 seconds}
\item \verb{1 hour == 3600 seconds}
\item \verb{1 minute == 60 seconds}
\item \verb{1 second == 1 second}
\item \verb{1 millisecond == 1 / 1000 seconds}
\item \verb{1 microsecond == 1 / 1000000 seconds}
\item \verb{1 nanosecond == 1 / 1000000000 seconds}
}

A duration of 1 year is defined to correspond to the
average length of a proleptic Gregorian year, i.e. 365.2425 days.

A duration of 1 month is defined as exactly 1/12 of a year.

A duration of 1 quarter is defined as exactly 1/4 of a year.

A duration of 1 week is defined as exactly 7 days.

These conversions come into play when doing operations like adding or
flooring durations. Generally, you add two calendrical durations together
to get a new calendrical duration, rather than adding a calendrical and
a chronological duration together. The one exception is \code{\link[=duration_cast]{duration_cast()}},
which can cast durations to any other precision, with a potential loss of
information.
}

\examples{
duration_years(1:5)
duration_nanoseconds(1:5)
}
