% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{fitted.clmstan}
\alias{fitted.clmstan}
\title{Fitted values for clmstan objects}
\usage{
\method{fitted}{clmstan}(
  object,
  newdata = NULL,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ndraws = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{clmstan} object returned by \code{\link[=clm_stan]{clm_stan()}}.}

\item{newdata}{Optional data frame for prediction. If \code{NULL} (default),
predictions are made for the original training data.}

\item{summary}{Logical. If \code{TRUE} (default), return summary statistics
(mean, SD, quantiles). If \code{FALSE}, return raw posterior draws.}

\item{robust}{Logical. If \code{TRUE}, use median instead of mean for
point estimates. Default is \code{FALSE}.}

\item{probs}{Numeric vector of probabilities for quantiles.
Default is \code{c(0.025, 0.975)} for 95\% credible intervals.}

\item{ndraws}{Number of posterior draws to use. If \code{NULL} (default),
all available draws are used.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
If \code{summary = TRUE} (default): A data frame with N rows and
columns for each category probability (\code{P[Y=1]}, \code{P[Y=2]}, etc.).
If \code{summary = FALSE}: An S x N x K array of probability draws.
}
\description{
Returns expected category probabilities for each observation.
This is equivalent to \code{predict(object, type = "probs", summary = TRUE)}.
}
\seealso{
\code{\link[=predict.clmstan]{predict.clmstan()}}, \code{\link[=posterior_predict.clmstan]{posterior_predict.clmstan()}}
}
