% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RtTriangle.R
\name{RtTriangle}
\alias{RtTriangle}
\title{Reverse time triangles}
\usage{
RtTriangle(cumulative.payments.triangle, k = 1/2)
}
\arguments{
\item{cumulative.payments.triangle}{Input triangle of cumulative payments.}

\item{k}{Claims exposure in the cell, also known as lost exposure.}
}
\value{
An object of class \code{"RtTriangle"}. Lists the following elements:
  \item{cumulative.payments.triangle}{Input triangle of cumulative payments.}
  
  \item{occurrance}{Matrix that contains the occurrance derived from the input triangle.}
  
  \item{exposure}{Matrix that contains the exposure derived from the input triangle, under the uniform claims arrival assumption.}
  
  \item{incremental.payments.triangle}{Triangle of incremental payments derived from the input.}
  
  \item{J}{Run-off triangle dimension.}
  
  \item{diagonal}{Cumulatives payments last diagonal.}
}
\description{
This function allows to define the class of triangles for reverse time models.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- RtTriangle(cumulative.payments.triangle=sifa.mtpl)

}
\references{
Hiabu, Munir. “On the relationship between classical chain ladder and granular reserving.” 
Scandinavian Actuarial Journal 2017 (2017): 708 - 729.
}
