% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-sessionInfo.R
\name{exportSessionInfoToMd}
\alias{exportSessionInfoToMd}
\title{Combine all session informations across all clinical data reports
and export them into a dedicated Markdown document}
\usage{
exportSessionInfoToMd(
  sessionInfos,
  intermediateDir = "interim",
  logFile = NULL,
  ...
)
}
\arguments{
\item{sessionInfos}{List with \code{\link{sessionInfo}} objects}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{logFile}{(optional) String with path to a log file,
where output (also error/messages/warnings) should be stored.
If specified, the entire output is re-directed to this file.}

\item{...}{Any parameters passed to \code{\link{renderFile}},
for expert use only.}
}
\value{
String with path to Markdown file containing the session information,
NULL if no session information(s) are provided.
}
\description{
Combine all session informations across all clinical data reports
and export them into a dedicated Markdown document
}
\author{
Laure Cougnaud
}
