% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plothist.R
\name{plothist}
\alias{plothist}
\title{Create a histogram of deltaAICc values}
\usage{
plothist(Dataset, DatasetRand = NA, HISTQ = 0.99)
}
\arguments{
\item{Dataset}{A dataframe containing information on all fitted climate
windows. Output from \code{\link{climatewin}}.}

\item{DatasetRand}{A dataframe containing information on all fitted climate
windows using randomised data. Output from \code{\link{randwin}}.}

\item{HISTQ}{If DatasetRand is provided. The quantile of the randomised data
that will be compared to non-randomised data. Used to determine the
likelihood of finding a climate window model of a given AICc value at
random.}
}
\value{
If DatasetRand is provided, plotall will return two stacked histograms
 to compare the deltaAICc of non-randomised and randomised data. This can
 help determine the likelihood of obtaining a deltaAICc value of fitted
 climate windows at random. Without DatasetRand, plotall will create a single
 histogram of deltaAICc values for all fitted climate windows.
}
\description{
Create a histogram of deltaAICc values for all fitted climate windows. Compare
with randomised data if provided.
}
\examples{
# Plot real and randomised data for the Mass dataset

data(MassOutput)
data(MassRand)

plothist(Dataset = MassOutput, DatasetRand = MassRand, HISTQ = 0.95)

# Plot deltaAICc when no randomised data is provided

data(MassOutput)

plothist(Dataset = MassOutput)
}
\author{
Liam D. Bailey and Martijn van de Pol
}

