\name{dahgrid}
\alias{dahgrid}
\title{Interpolation of normalized homogeneous data on a predefined grid}
\description{
  Homogenized data generated by \code{\link{homogen}} are normalized and
  interpolated on a grid provided by the user at every time step, and saved in
  a NetCDF file.
}
\usage{
dahgrid(varcli, anyi, anyf, anyip=anyi, anyfp=anyf, grid, mh=FALSE, std=NA,
ini=NA, obsonly=TRUE)
}
\arguments{
  \item{varcli}{Acronym of the name of the studied climatic variable,
    as in the data file name.}
  \item{anyi}{Initial year of the homogenized data.}
  \item{anyf}{Final year of the homogenized data.}
  \item{anyip}{First year of the desired reference period. (The reference period defaults to the whole period of the data).}
  \item{anyfp}{Last year of the desired reference period.}
  \item{grid}{Grid on which interpolations must be performed.}
  \item{mh}{If \code{TRUE}, read monthly data from file \file{*-mh_*.dat} (generated when daily homogenized series are aggregated into monthly).}
  \item{std}{Type of normalization:
    \describe{
      \item{1:}{deviations from the mean,}
      \item{2:}{rates to the mean (only for means greater than 1),}
      \item{3:}{standardization (subtract the mean and divide by the
        standard deviation of the sample).}
    }
  }
  \item{ini}{Initial date (first of January of \code{anyi} by default. This parameter is included in the \file{*.rda} file, but this file is not read when \code{mh=TRUE}.}
  \item{obsonly}{Do not interpolate estimated missing data. (\code{TRUE} by
  default).}
}
\details{
  Homogenized data are read from the binary file \file{VAR_ANYI-ANYF.rda}
  generated by \code{\link{homogen}}. Only series reconstructed from their
  longest homogeneous sub-period are retained, and they are normalized by their
  means (and standard deviations, if \code{std=3}), computed for the selected
  reference period (or for the whole period of the data, by default).

  Unless \code{obsonly} is set to \code{FALSE}, data that were missing in the
  observed series are deleted to avoid interpolation of already interpolated
  data.
  
  Finally, the normalized homogeneous data are interpolated on the predefined
  grid for every time step using an inverse distance weight method, and the
  resulting grids are stored in a NetCDF file named \file{VAR_ANYIP-ANYFP.nc},
  including grids of the reference means (and standard deviations, if applied).

  The user must provide the grid as an object of class SpatialPixel, as in this
  example defining a grid from 40N,3E to 43N,7E with a resolution of 0.1
  degrees:

  \code{grid <- expand.grid(x=seq(3,7,.1),y=seq(40,43,.1))}\cr
  \code{library(sp)}\cr
  \code{coordinates(grid) <- ~ x+y}

  The resolution of this grid need not be too high, but adjusted to the spatial
  density of the available series.

  The user may be more interested in obtaining grids of absolute values, rather
  than normalized. This can be achieved simply by undoing the normalization on
  the grids with the help of the provided grids of reference means and standard
  deviations. However, the resulting grids will only be the product of a
  geometrical interpolation, and will not reflect the influence of orography
  and other physiographic effects on the studied climatic variable. Therefore,
  it is more advisable to derive better reference grids of means (and standard
  deviations, if needed) by applying a geostatistical model to the reference
  means (provided in the file \file{VAR_ANYIP-ANYFP_means.csv} with their
  corresponding coordinates).
  
  This better quality climatic maps will probably have a higher resolution than
  that of the grids of the NetCDF file provided by this function. In that case,
  these normalized grids must be interpolated to the grid of the
  geostatistically derived climatic maps before undoing the normalization to
  obtain the final maps of absolute values at all or selected time-steps of the
  studied period.
}
\value{
  This function does not return any value, since the results are stored in
  files.
}
\seealso{\code{\link{homogen}}}
\examples{
if(requireNamespace("ncdf4") & requireNamespace("sp")) {
  #Set a temporal working directory and write input files:
  wd <- tempdir()
  wd0 <- setwd(wd)
  data(pcp_results) #Load homogenization data
  #Write homogenization results as expected by the dahgrid function:
  save(dah,dat,est.c,ini,nd,ndec,ne,nei,nm,std,x,file='pcp_2001-2010.rda')
  #Now run the example:
  grd <- expand.grid(x=seq(2.9,3.3,.1),y=seq(39.5,39.7,.1))
  sp::coordinates(grd) <- ~ x+y
  dahgrid('pcp',2001,2010,grid=grd)
  #Return to user's working directory:
  setwd(wd0)
  #Input and output files can be found in directory:
  print(wd)
}
}
\keyword{datagen}

