% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clickstream.r
\name{as.ClickClust}
\alias{as.ClickClust}
\title{Coerces a Clickstream Object to a ClickClust Object}
\usage{
as.ClickClust(clickstreamList)
}
\arguments{
\item{clickstreamList}{A list of clickstreams.}
}
\value{
A list consisting of a dataset X and a vector of initial states y
}
\description{
Coerces a \code{Clickstream} object to a \code{ClickClust} object.
}
\examples{

clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
X <- as.ClickClust(cls)

}
\seealso{
\code{\link{frequencies}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
