% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Fitting.r
\name{clusterClickstreams}
\alias{clusterClickstreams}
\title{Performs K-Means Clustering on a List of Clickstreams}
\usage{
clusterClickstreams(clickstreamList, order = 0, centers, ...)
}
\arguments{
  \item{clickstreamList}{A list of clickstreams for which
  the cluster analysis is performed.} \item{order}{The order
  of the transition matrices used as input for clustering
  (default is 0).} \item{centers}{The number of clusters.}
  \item{...}{Additional parameters for k-means clustering
  (see \code{\link{kmeans}}).}
}
\value{
This method returns a \code{ClickstreamClusters} object
(S3-class). It is a list with the following components:
\item{clusters}{ The resulting list of \code{Clickstreams}
objects.} \item{centers}{ A matrix of cluster centres. }
\item{states}{ Vector of states} \item{totss}{ The total
sum of squares. } \item{withinss}{ Vector of within-
cluster sum of squares, one component per cluster. }
\item{tot.withinss}{ Total within-cluster sum of squares,
i.e., \code{sum(withinss)}. } \item{betweenss}{ The between-
cluster sum of squares, i.e., \code{totss - tot.withinss}. }
}
\description{
Performs k-means clustering on a list of clickstreams. For
each clickstream a transition matrix of a given order is
computed. These transition matrices are used as input for
performing k-means clustering.
}
\examples{
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
clusters <- clusterClickstreams(cls, order = 0, centers = 2)
print(clusters)
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\seealso{
\code{\link{print.ClickstreamClusters}},
\code{\link{summary.ClickstreamClusters}}
}

