% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_functions.R
\name{fix_numerics}
\alias{fix_numerics}
\alias{fix.numerics}
\title{Fix numeric data}
\usage{
fix_numerics(x, k = 8, max.NA = 0.2, track = TRUE)

fix.numerics(x, k = 8, max.NA = 0.2, track = TRUE)
}
\arguments{
\item{x}{A data.frame}

\item{k}{Minimum number of different values a variable has to have to be considered numerical}

\item{max.NA}{Maximum allowed proportion of NA values created by coercion. If the
coercion to numeric creates more NA values than those specified in \code{max.NA}, then all
changes will be reverted and the variable will remain unchanged.}

\item{track}{Keep track of changes?}
}
\description{
Fixes numeric data. In may cases, numeric data are not recognized by R
because there are data inconsistencies (wrong decimal separator, whitespaces, typos,
thousand separator, etc.). \code{fix_numerics} detects and corrects these variables,
making them numeric again.
}
\examples{
mydata<-data.frame(Numeric1=c(7.8, 9.2, "5.4e+2", 3.3, "6,8", "3..3"),
                   Numeric2=c(3.1, 1.2, "3.4s", "48,500.04 $", 7, "$  6.4"))
descriptive(mydata)
descriptive(fix_numerics(mydata, k=5))
}
