% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_names.R
\name{format_names}
\alias{format_names}
\title{Format names and values}
\usage{
format_names(
  x,
  ...,
  snake_case = FALSE,
  camelCase = FALSE,
  tolower = FALSE,
  toupper = FALSE
)
}
\arguments{
\item{x}{a \code{data.frame}, \code{list} or \code{character} vector}

\item{...}{when \code{x} is a \code{data.frame}: new column names to set, which can be named (in the form \code{old = "new"}). The original column names do not need to be quoted, see Examples.}

\item{snake_case}{logical to indicate whether the column names must be in \href{https://en.wikipedia.org/wiki/Snake_case}{snake case}. This will have no effect on manually set column names.}

\item{camelCase}{logical to indicate whether the column names must be in \href{https://en.wikipedia.org/wiki/Camel_case}{camel case}. This will have no effect on manually set column names.}

\item{tolower, toupper}{logical to indicate whether the column names must be lower/upper case. This will have no effect on manually set column names.}
}
\description{
This function can be used on any \code{data.frame}, \code{list} or character vector to format their names or values. It supports \href{https://en.wikipedia.org/wiki/Snake_case}{snake case} and \href{https://en.wikipedia.org/wiki/Camel_case}{camel case}.
}
\examples{
df <- data.frame(Name.341ABC = "value", 
                 name_123def = "value",
                 This.is.a.column = "value")
                 
format_names(df, snake_case = TRUE)

format_names(df, camelCase = TRUE)

format_names(df, letters[1:3])

format_names(df, This.is.a.column = "a_new_colname")

rownames(mtcars) <- format_names(rownames(mtcars), snake_case = TRUE)
mtcars[, 1:5]

format_names(list(a = 1, b = 2), c("new_1", "new_2"))

\dontrun{
library(dplyr)
starwars \%>\%
  format_names(camelCase = TRUE) \%>\%        # new column names
  mutate(name = name \%>\% 
           format_names(name, 
                        snake_case = TRUE)) # new values in column
}
}
