% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_put_syncs_archive}
\alias{imports_put_syncs_archive}
\title{Update the archive status of this sync}
\usage{
imports_put_syncs_archive(id, sync_id, status = NULL)
}
\arguments{
\item{id}{integer required. The ID of the import to fetch.}

\item{sync_id}{integer required. The ID of the sync to fetch.}

\item{status}{boolean optional. The desired archived status of the sync.}
}
\value{
A list containing the following elements:
\item{id}{integer, }
\item{source}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of the table or file, if available.
\item path string, The path of the dataset to sync from; for a database source, schema.tablename. If you are doing a Google Sheet export, this can be blank. This is a legacy parameter, it is recommended you use one of the following: databaseTable, file, googleWorksheet, salesforce
\item databaseTable list . A list containing the following elements: 
\itemize{
\item schema string, The database schema name.
\item table string, The database table name.
\item useWithoutSchema boolean, This attribute is no longer available; defaults to false but cannot be used.
}
\item file list . A list containing the following elements: 
\itemize{
\item id integer, The file id.
}
\item googleWorksheet list . A list containing the following elements: 
\itemize{
\item spreadsheet string, The spreadsheet document name.
\item spreadsheetId string, The spreadsheet document id.
\item worksheet string, The worksheet tab name.
\item worksheetId integer, The worksheet tab id.
}
\item salesforce list . A list containing the following elements: 
\itemize{
\item objectName string, The Salesforce object name.
}
}}
\item{destination}{list, A list containing the following elements: 
\itemize{
\item path string, The schema.tablename to sync to. If you are doing a Google Sheet export, this is the spreadsheet and sheet name separated by a period. i.e. if you have a spreadsheet named "MySpreadsheet" and a sheet called "Sheet1" this field would be "MySpreadsheet.Sheet1". This is a legacy parameter, it is recommended you use one of the following: databaseTable, googleWorksheet
\item databaseTable list . A list containing the following elements: 
\itemize{
\item schema string, The database schema name.
\item table string, The database table name.
\item useWithoutSchema boolean, This attribute is no longer available; defaults to false but cannot be used.
}
\item googleWorksheet list . A list containing the following elements: 
\itemize{
\item spreadsheet string, The spreadsheet document name.
\item spreadsheetId string, The spreadsheet document id.
\item worksheet string, The worksheet tab name.
\item worksheetId integer, The worksheet tab id.
}
}}
\item{advancedOptions}{list, A list containing the following elements: 
\itemize{
\item maxErrors integer, 
\item existingTableRows string, 
\item diststyle string, 
\item distkey string, 
\item sortkey1 string, 
\item sortkey2 string, 
\item columnDelimiter string, 
\item columnOverrides object, Hash used for overriding auto-detected names and types, with keys being the index of the column being overridden.
\item escaped boolean, If true, escape quotes with a backslash; otherwise, escape quotes by double-quoting. Defaults to false.
\item identityColumn string, 
\item rowChunkSize integer, 
\item wipeDestinationTable boolean, 
\item truncateLongLines boolean, 
\item invalidCharReplacement string, 
\item verifyTableRowCounts boolean, 
\item partitionColumnName string, This parameter is deprecated
\item partitionSchemaName string, This parameter is deprecated
\item partitionTableName string, This parameter is deprecated
\item partitionTablePartitionColumnMinName string, This parameter is deprecated
\item partitionTablePartitionColumnMaxName string, This parameter is deprecated
\item lastModifiedColumn string, 
\item mysqlCatalogMatchesSchema boolean, This attribute is no longer available; defaults to true but cannot be used.
\item chunkingMethod string, The method used to break the data into smaller chunks for transfer.  The value can be set to sorted_by_identity_columns or if not set the chunking method will be chosen automatically.
\item firstRowIsHeader boolean, 
\item exportAction string, The kind of export action you want to have the export execute. Set to "newsprsht" if you want a new worksheet inside a new spreadsheet. Set to "newwksht" if you want a new worksheet inside an existing spreadsheet. Set to "updatewksht" if you want to overwrite an existing worksheet inside an existing spreadsheet. Set to "appendwksht" if you want to append to the end of an existing worksheet inside an existing spreadsheet. Default is set to "newsprsht"
\item sqlQuery string, If you are doing a Google Sheet export, this is your SQL query.
\item contactLists string, 
\item soqlQuery string, 
\item includeDeletedRecords boolean, 
}}
}
\description{
Update the archive status of this sync
}
