% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{imports_post_files}
\alias{imports_post_files}
\title{Initate an import of a tabular file into the platform}
\usage{
imports_post_files(schema, name, remote_host_id, credential_id,
  max_errors = NULL, existing_table_rows = NULL, diststyle = NULL,
  distkey = NULL, sortkey1 = NULL, sortkey2 = NULL,
  column_delimiter = NULL, first_row_is_header = NULL, multipart = NULL,
  hidden = NULL)
}
\arguments{
\item{schema}{string required. The schema of the destination table.}

\item{name}{string required. The name of the destination table.}

\item{remote_host_id}{integer required. The id of the destination database host.}

\item{credential_id}{integer required. The id of the credentials to be used when performing the database import.}

\item{max_errors}{integer optional. The maximum number of rows with errors to remove from the import before failing.}

\item{existing_table_rows}{string optional. The behaviour if a table with the requested name already exists.  One of "fail", "truncate", "append", or "drop".Defaults to "fail".}

\item{diststyle}{string optional. The diststyle to use for the table. One of "even", "all", or "key".}

\item{distkey}{string optional. The column to use as the distkey for the table.}

\item{sortkey1}{string optional. The column to use as the sort key for the table.}

\item{sortkey2}{string optional. The second column in a compound sortkey for the table.}

\item{column_delimiter}{string optional. The column delimiter of the file. If column_delimiter is null or omitted, it will be auto-detected. Valid arguments are "comma", "tab", and "pipe".}

\item{first_row_is_header}{boolean optional. A boolean value indicating whether or not the first row is a header row. If first_row_is_header is null or omitted, it will be auto-detected.}

\item{multipart}{boolean optional. If true, the upload URI will require a `multipart/form-data` POST request. Defaults to false.}

\item{hidden}{boolean optional. The hidden status of the item.}
}
\value{
A list containing the following elements:
\item{id}{integer, The id of the import.}
\item{uploadUri}{string, The URI which may be used to upload a tabular file for import. You must use this URI to upload the file you wish imported and then inform the Civis API when your upload is complete using the URI given by the runUri field of this response.}
\item{runUri}{string, The URI to POST to once the file upload is complete. After uploading the file using the URI given in the uploadUri attribute of the response, POST to this URI to initiate the import of your uploaded file into the platform.}
\item{uploadFields}{list, If multipart was set to true, these fields should be included in the multipart upload.}
}
\description{
Initate an import of a tabular file into the platform
}
