% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\docType{class}
\name{ccTrack-class}
\alias{ccTrack-class}
\title{S4 class ccTrack}
\description{
S4 class ccTrack
}
\section{Slots}{

\describe{
\item{\code{func}}{character. Normally it is "circos.track" or "circos.trackHist".}

\item{\code{params}}{list. A \strong{named} list that stores the parameters of the function called by the backend.}

\item{\code{trackGeoms}}{list. A list where \linkS4class{ccTrackGeom} are stored.}

\item{\code{cells}}{list. A list where \linkS4class{ccCell} are stored.}
}}

\examples{
n = 1000
df = data.frame(sectors = sample(letters[1:8], n, replace = TRUE),
                x = rnorm(n), y = runif(n))
library(circlizePlus)
par1=ccPar("track.height" = 0.1)
cc=ccPlot(sectors = df$sectors, x = df$x) + par1
track1 = ccTrack(sectors = df$sectors, y = df$y,
                 panel.fun = function(x, y) {
                   circos.text(CELL_META$xcenter,
                               CELL_META$cell.ylim[2] + mm_y(5),
                               CELL_META$sector.index)
                   circos.axis(labels.cex = 0.6)
                 })
cc=cc+track1
cc
circos.clear()
}
