% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_cifti.R
\name{separate_cifti}
\alias{separate_cifti}
\alias{separateCIfTI}
\alias{separatecii}
\title{Separate a CIFTI file}
\usage{
separate_cifti(
  cifti_fname,
  brainstructures = NULL,
  cortexL_fname = NULL,
  cortexR_fname = NULL,
  subcortVol_fname = NULL,
  subcortLabs_fname = NULL,
  ROI_brainstructures = "all",
  ROIcortexL_fname = NULL,
  ROIcortexR_fname = NULL,
  ROIsubcortVol_fname = NULL,
  write_dir = NULL
)

separateCIfTI(
  cifti_fname,
  brainstructures = c("left", "right"),
  cortexL_fname = NULL,
  cortexR_fname = NULL,
  subcortVol_fname = NULL,
  subcortLabs_fname = NULL,
  ROI_brainstructures = "all",
  ROIcortexL_fname = NULL,
  ROIcortexR_fname = NULL,
  ROIsubcortVol_fname = NULL,
  write_dir = NULL
)

separatecii(
  cifti_fname,
  brainstructures = c("left", "right"),
  cortexL_fname = NULL,
  cortexR_fname = NULL,
  subcortVol_fname = NULL,
  subcortLabs_fname = NULL,
  ROI_brainstructures = "all",
  ROIcortexL_fname = NULL,
  ROIcortexR_fname = NULL,
  ROIsubcortVol_fname = NULL,
  write_dir = NULL
)
}
\arguments{
\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}

\item{brainstructures}{(Optional) character vector indicating a subset of
brain structure(s) to write: \code{"left"} cortex, \code{"right"} cortex,
and/or \code{"subcortical"} structures. Can also be \code{"all"} to write
out all existing brain structures. Default: \code{c("left","right")}.}

\item{cortexL_fname, cortexR_fname}{(Optional) GIFTI file names
(*.[func/label].gii) to save the [left/right] cortex data to.
dtseries and dscalar files should use "func", whereas dlabel files should
use "label".

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*[L/R].\[func/label\].gii"}, where * is the file name component of
\code{cifti_fname}.}

\item{subcortVol_fname, subcortLabs_fname}{(Optional) NIFTI file names to save
the subcortical [volume/labels] to. Provide both or neither.

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*[/.labels].nii"}, where * is the file name component of
\code{cifti_fname}.}

\item{ROI_brainstructures}{Which ROIs should be obtained? \code{"all"}
(default) to obtain ROIs for each of the \code{brainstructures}. \code{NULL}
to not obtain any ROIs. This should be a subset of \code{brainstructures}.}

\item{ROIcortexL_fname, ROIcortexR_fname}{(Optional) GIFTI file names
(*.[func/label].gii) to save the [left/right] cortex ROI to.
dtseries and dscalar files should use "func", whereas dlabel files should
use "label".

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*ROI_[L/R].\[func/label\].gii"}, where * is the file name component of
\code{cifti_fname}.

The cortical ROIs typically represent the medial wall
mask, with values of 1 for in-ROI (non-medial wall) vertices and 0 for
out-of-ROI (medial wall) vertices. Will be written in \code{write_dir}.}

\item{ROIsubcortVol_fname}{(Optional) NIFTI file names to save
the subcortical ROI to.

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*ROI.nii"}, where * is the file name component of
\code{cifti_fname}.

The subcortical ROI typically represents the volumetric
mask for the entire subcortical structure, with values of 1 for in-ROI
(in subcortex) voxels and 0 for out-of-ROI (not in subcortex) voxels. Will
be written in \code{write_dir}.}

\item{write_dir}{(Optional) A path to an existing directory. If provided,
every component in the \code{"xifti"} will be written to this directory,
using automatically-generated names if their \code{*_fname} argument was
not provided. Otherwise if \code{write_dir} is \code{NULL}, only the
components for which their \code{*_fname} was provided will be written.}
}
\value{
A named character vector with the file paths to the written
NIFTI and GIFTI files
}
\description{
Separate a CIFTI file into GIFTI files for the cortical data and NIFTI files
for the subcortical data and labels. ROIs can also be written to indicate
the medial wall mask (cortex) and volume mask (subcortex). This uses the
Connectome Workbench command \code{-cifti-separate}.
}
\details{
Time unit, start, and step (dtseries files) will not be written to the GIFTI/NIFTIs.
Column names (dscalar files) will not be written to the GIFTIs, as well as label
names and colors (dlabel files). (Haven't checked the NIFTIs yet.)

ROI/medial wall behavior: If there are 32k vertices in the left cortex with
3k representing the medial wall, then both \code{cortexL_fname} and
\code{ROIcortexL_fname} will have 32k entries, 3k of which having a value of
0 indicating the medial wall. The non-medial wall entries will have the
data values in \code{cortexL_fname} and a value of 1 in
\code{ROIcortexL_fname}. Thus, exporting \code{ROIcortexL_fname} is vital if
the data values include 0, because 0-valued non-medial wall vertices and
medial wall vertices cannot be distinguished from one another within
\code{cortexL_fname} alone.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-cifti-separate"} Workbench command.
}

\seealso{
Other writing: 
\code{\link{write_cifti}()},
\code{\link{write_metric_gifti}()},
\code{\link{write_subcort_nifti}()},
\code{\link{write_surf_gifti}()},
\code{\link{write_xifti2}()}
}
\concept{writing}
