% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile_glm.R
\name{add_quantile.glm}
\alias{add_quantile.glm}
\title{Quantiles for the Response of a Generalized Linear Model}
\usage{
\method{add_quantile}{glm}(tb, fit, p, name = NULL, yhatName = "pred",
  nSims = 200, ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{glm}. Predictions are made with
this object.}

\item{p}{A real number between 0 and 1. Sets the probability level
of the quantiles.}

\item{name}{\code{NULL} or a string. If \code{NULL},
quantiles automatically will be named by \code{add_quantile},
otherwise, they will be named \code{name}.}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{nSims}{A positive integer. Set the number of simulated draws
to use.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values and level
    \emph{p} quantiles attached.
}
\description{
This function is one of the methods of
\code{add_quantile}. Currently, you can only use this function to
compute the quantiles of the response of a Poisson regression with
the \eqn{\log}-link function.
}
\details{
Quantiles of generalized linear models are determined by
\code{add_quantile} through a simulation using \code{arm::sim}.
}
\examples{

# Fit a Poisson GLM
fit <- glm(dist ~ speed, data = cars, family = "poisson")

# What is the 0.3-quantile (or 30th percentile) of new distances,
# given the Poisson model?
add_quantile(cars, fit, p = 0.3)

# As above, but now find the 0.5-quantile (50th percentile), change
# the number of simulations to run, and give the vector of
# quantiles a custom name.
add_quantile(cars, fit, p = 0.5, name = "my_quantile", nSims = 300)

}
\seealso{
\code{\link{add_ci.lm}} for confidence intervals for
    \code{lm} objects, \code{\link{add_pi.lm}} for prediction
    intervals of \code{lm} objects, and \code{\link{add_probs.lm}}
    for response probabilities of \code{lm} objects.
}
