% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_chunkwise}
\alias{read_chunkwise}
\alias{read_chunkwise.character}
\alias{read_chunkwise.laf}
\alias{read_chunkwise.tbl_sql}
\title{Read chunkwise from a data source}
\usage{
read_chunkwise(src, chunk_size = 10000L, ...)

\method{read_chunkwise}{character}(
  src,
  chunk_size = 10000L,
  format = c("csv", "csv2", "table"),
  stringsAsFactors = default.stringsAsFactors(),
  ...
)

\method{read_chunkwise}{laf}(src, chunk_size = 10000L, ...)

\method{read_chunkwise}{tbl_sql}(src, chunk_size = 10000L, ...)
}
\arguments{
\item{src}{source to read from}

\item{chunk_size}{size of the chunks}

\item{...}{parameters used by specific classes}

\item{format}{used for specifying type of text file}

\item{stringsAsFactors}{\code{logical} should string be read as factors?}
}
\value{
an object of type tbl_chunk
}
\description{
Read chunkwise from a data source
}
