% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromoMap.R
\name{chromoMap}
\alias{chromoMap}
\title{render interactive chromosome plots of any living organism and annotate elements}
\usage{
chromoMap(ch.files, data.files, title = c(), ch_gap = 5, ploidy = 1,
  top_margin = 25, left_margin = 40, chr_width = 6, chr_length = 4,
  chr_color = c("black"), data_based_color_map = FALSE,
  v_align = FALSE, segment_annotation = FALSE, lg_x = 0, lg_y = 0,
  data_type = c("numeric", "categorical"), labels = FALSE,
  canvas_width = 500, canvas_height = 520, data_colors = list(),
  anno_col = c("yellow"), chr_text = c(TRUE), legend = c(FALSE),
  hlinks = FALSE, aggregate_func = c("avg"))
}
\arguments{
\item{ch.files}{filename(s) containing co-ordinates of the chromosomes to render}

\item{data.files}{filename(s) containing data to annotate on the chromosomes.}

\item{title}{a character string to be used as a title in plot}

\item{ch_gap}{provide spacing between chromosomes.}

\item{ploidy}{specify the number of sets of chromsomes being passed.}

\item{top_margin}{specify the margin from top of the plot}

\item{left_margin}{specify the margin from the left of the plot}

\item{chr_width}{specify the width of each chromsome}

\item{chr_length}{specify the length of each chromsome.}

\item{chr_color}{a vector specifying the color of each chromsome in a set. A color
can be assigned to each set by passing a different color values as vector}

\item{data_based_color_map}{a boolean to tell the plot to use the data provided in file for
visualizing annotation}

\item{v_align}{a boolean for vertical alignment of plot}

\item{segment_annotation}{a boolean to use segment-annotation algorithm}

\item{lg_x}{specify the x or horizontal distance of the legend from origin(bottom right corner)}

\item{lg_y}{specify the y or vertical distnce of the legend from the origin}

\item{data_type}{specifying the data type of the data used. takes value either 'categorical' or
'numeric'}

\item{labels}{a boolean to include labels in plot}

\item{canvas_width}{width of the plot}

\item{canvas_height}{height of the plot}

\item{data_colors}{specify annotation colors for the data}

\item{anno_col}{a vector to specify annotation color for each set.}

\item{chr_text}{a boolean vector to enable or disable chromsome texts for each ploidy.set}

\item{legend}{a boolean vector to enable or disable legend for each set/ploidy}

\item{hlinks}{a boolean to use hyperlinks supplied in data}

\item{aggregate_func}{takes either 'sum' or 'avg' to specift aggregate function for each loci}
}
\description{
render an interactive graphics visualization of entire chromosomes
 or chromosomal regions of any living organism. Chromosomal elements such as genes 
 can be annotated easily using this tool.

required for creating widgets
}
\examples{
\dontrun{

library(chromoMap)

#simple annotations
chromoMap("chromosome_file.txt","annotation_file.txt")

#polyploidy example
chromoMap(c("chromosome_set1.txt","chromosome_set2.txt"),
          c("annotation_set1.txt","annotation_set2.txt"), ploidy=2)

#plotting group annotation
chromoMap("chromosome_file.txt","annotation_file.txt",
           data_base_color_map=T, data_type="categorical")

#plotting chromsome heatmaps
chromoMap("chromosome_file.txt","annotation_file.txt",
           data_based_color_map=T, data_type="numeric")

#enabling hyperlinks
chromoMap("chromosome_file.txt","annotation_file.txt", hlinks=T)

#enabling labels
chromoMap("chromosome_file.txt","annotation_file.txt", labels=T)

#change chromosome color
chromoMap("chromosome_file.txt","annotation_file.txt", chr_color="red")

}





}
