% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chroms.R
\name{read_chroms}
\alias{read_chroms}
\title{Read Chromatograms}
\usage{
read_chroms(
  paths,
  find_files = TRUE,
  format.in = c("chemstation.uv", "masshunter.dad"),
  pattern = NULL,
  parser = c("Aston"),
  R.format = c("matrix", "data.frame"),
  export = FALSE,
  path.out = NULL,
  format.out = "csv",
  dat = NULL
)
}
\arguments{
\item{paths}{paths to files or folders containing files}

\item{find_files}{TRUE}

\item{format.in}{Format of files to be imported/converted.}

\item{pattern}{pattern (e.g. a file extension). Defaults to NULL, in which
case file extension will be deduced from \code{format.in}.}

\item{parser}{= What parser to use. Currently, the only option is \code{Aston}.}

\item{R.format}{R object format (i.e. data.frame or matrix).}

\item{export}{Logical. If true, will export files as csvs.}

\item{path.out}{Path for exporting files. If path not specified, files will
export to current working directory.}

\item{format.out}{Output format. Currently only \code{.csv}.}

\item{dat}{Existing list of chromatograms to append results.
(Defaults to NULL).}
}
\value{
A list of chromatograms in matrix or data.frame format, according to
the value of 'R.format'.
}
\description{
Reads chromatograms from specified folders or vector of paths using the
\href{https://github.com/bovee/aston}{Aston} file parser.
}
\details{
Currently recognizes Agilent ChemStation '.uv' and MassHunter '.dad' files.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
path <- "tests/testthat/testdata/dad1.uv"
chr <- read_chroms(path, find_files = FALSE, format.in = "chemstation.uv")
\dontshow{\}) # examplesIf}
}
\author{
Ethan Bass
}
