% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_congressional_demographics.R
\name{filter_to_voting_congressional_districts}
\alias{filter_to_voting_congressional_districts}
\title{Remove non-voting Congressional Districts from a data.frame}
\usage{
filter_to_voting_congressional_districts(df)
}
\arguments{
\item{df}{A data.frame. Must have a column named region that contains character vectors of length 4. The first 2 characters should be a state FIPS code and the second 2 characters should be a Congressional District Number}
}
\description{
The data.frame must have a column named region with a 4-character Congressional District code.
Remove districts that have a district code of 98 (non-voting) or ZZ (undefined district). See 
https://www.census.gov/geographies/mapping-files/2019/dec/rdo/116-congressional-district-bef.html
At the time this function was created, tidycensus returned 5 non-voting districts. See 
https://github.com/walkerke/tidycensus/issues/277
}
