% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateFatalities.R
\name{simulateFatalities}
\alias{simulateFatalities}
\title{Generate simulated fatalities and their orthogonal projections.}
\usage{
simulateFatalities(compute = FALSE, multi.core = FALSE,
  simulated.obs = 5000L)
}
\arguments{
\item{compute}{Logical. TRUE computes data. FALSE uses pre-computed data. For replication of data used in the package, FALSE is the default.}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. With Numeric, you specify the number logical cores (rounds with as.integer()). On Windows, only "multi.core = FALSE" is available.}

\item{simulated.obs}{Numeric. Number of sample cases. Default is 5000.}
}
\value{
An R list with two elements: \code{\link{sim.ortho.proj}} and \code{\link{regular.cases}}
}
\description{
Places regularly spaced "simulated" cases across the face of the map. These cases are then orthogonally projected onto the road network, which are used to generate "expected" cases, paths and neighborhoods. The function relies on sp::spsample() and sp::Polygon().
}
\section{Notes}{
 This function is computationally intensive. On a 2.3 GHz Intel Core i7, it takes approximately 31 minutes to run on one core and approximately 7 minutes to run on eight logical (four physical) cores. This function documents the code that generates \code{\link{sim.ortho.proj}} and \code{\link{regular.cases}}.
}

