% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-all-identical.R
\name{chk_all_identical}
\alias{chk_all_identical}
\alias{vld_all_identical}
\title{Check All Identical}
\usage{
chk_all_identical(x, x_name = NULL)

vld_all_identical(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks all elements in x identical using

\code{length(x) < 2L || all(vapply(x, vld_identical, TRUE, y = x[[1]]))}

\strong{Good}: \code{c(1, 1.00000001)}, \code{list(1, 1)}

\strong{Bad}: \code{c(1, 1.0000001)}, \code{list(1, NA)}
}
\section{Functions}{
\itemize{
\item \code{vld_all_identical}: Validate All Identical
}}

\examples{

# chk_all_identical
chk_all_identical(c(1, 1))
try(chk_all_identical(c(1, 1.1)))

# vld_all_identical
vld_all_identical(c(1, 1))
}
\seealso{
Other chk_alls: 
\code{\link{chk_all_equal}()},
\code{\link{chk_all_equivalent}()},
\code{\link{chk_all}()}
}
\concept{chk_alls}
