% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_rel_change_scenario.R
\name{gen_rel_change_scenario}
\alias{gen_rel_change_scenario}
\title{Generates relative climate change scenarios based on extracted CMIP6 data}
\usage{
gen_rel_change_scenario(
  downloaded_list,
  years_local_weather,
  weather_list = NULL,
  times = c(2050, 2085),
  baseline_year_relative_change = 2022,
  baseline_window_width = 15,
  future_window_width = 31
)
}
\arguments{
\item{downloaded_list}{list of data.frames, generated using the
extract_cmip6_data function. Elements are named after the shared socioeconomic
pathway ('SSP') and global climate model ('GCM')}

\item{years_local_weather}{by default set to NULL. If provided, this states
the earliest and latest baseline year for which the relative scenario should
be generated. The same values will be used for all weather stations in this
case. Either years_local_weather or weather_list needs to be provided.}

\item{weather_list}{by default set to NULL. If provided, should be a list of
data.frames containing the locally observed weather. This is used to determine
the earliest and latest years for which we have observations.}

\item{times}{numeric vector, states the future years, for which the climate
change scenario should be generated. By default set to c(2050, 2085).}

\item{baseline_year_relative_change}{numeric, states for which year within
the downloaded CMIP6 data the relative change should be calculated.
By default set to 2022.}

\item{baseline_window_width}{numeric, sets the window width of the running
mean calculation for the mean temperatures of the year indicated by
baseline_year_relative_change.}

\item{future_window_width}{numeric, sets the window width of the running mean
calculation for the mean temperatures of the years indicated by times.}
}
\value{
list of relative climate change scenarios. The list is ordered by
three levels: 1) location 2) SSP_GCM and 3) timepoint of interest.
}
\description{
Takes the extracted CMIP6 data and returns climate change scenarios, which
can then be used to generate weather data.
}
\examples{
\dontrun{
download_cmip6_ecmwfr(scenario = 'ssp1_2_6', 
                      area = c(55, 5.5, 47, 15.1),
                      user = 'write user id here'
                      key = 'write key here',
                      model = 'AWI-CM-1-1-MR',
                      frequency = 'monthly', 
                      variable = c('Tmin', 'Tmax'),
                      year_start = 2015, 
                      year_end = 2100)
station <- data.frame(
      station_name = c('Zaragoza', 'Klein-Altendorf', 'Sfax',
      'Cieza', 'Meknes', 'Santomera'),
      longitude = c(-0.88,  6.99, 10.75, -1.41, -5.54, -1.05),
      latitude = c(41.65, 50.61, 34.75, 38.24, 33.88, 38.06))
      
      extracted <- extract_cmip6_data(stations = station)
      extracted$`ssp126_AWI-CM-1-1-MR`
      scenario <- gen_rel_change_scenario(extracted, years_local_weather = c(1992, 2021))
      scenario$`Klein-Altendorf`$`ssp126_AWI-CM-1-1-MR`$'2050'
}

}
\author{
Lars Caspersen
}
