% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_phenology_trends.R
\name{plot_phenology_trends}
\alias{plot_phenology_trends}
\title{Visualizing phenology responses to temperatures during two phases}
\usage{
plot_phenology_trends(
  pheno_data,
  weather_data,
  split_month = 6,
  chilling_phase,
  forcing_phase,
  Krig_warn = TRUE,
  x_axis_name = NULL,
  y_axis_name = NULL,
  legend_name = NULL,
  contour_line_color = "black",
  point_color = "black",
  point_shape = 19,
  legend_colors = NULL,
  base_size = 11,
  ...
)
}
\arguments{
\item{pheno_data}{is a data frame that contains information on the timing of phenology events by year.
It should consist of two columns called \code{Year} and \code{pheno}. Data in the \code{pheno} column should be in
Julian date (day of the year).}

\item{weather_data}{is a data frame containing daily minimum and maximum temperature data (in columns
called \code{Tmin} and \code{Tmax}, respectively). There also has to be a column for \code{Year}, one for
\code{Month} and one for \code{Day}. It can also contain a column for \code{JDay}
(the Julian date, or day of the year).}

\item{split_month}{is an integer representing the last month of the growing season. This procedure analyzes
data by phenology year, which can start and end in any month during the calendar year (currently only
at the beginning of a month). This variable indicates the last month (e.g. 5 for May) that should be
included in the record for a given phenology year. All subsequent months are assigned to the 
following phenology year.}

\item{chilling_phase}{is a vector of integers representing the start and end for the chilling period
in temperate trees. Numbers must be provided in Julian date (day of the year).}

\item{forcing_phase}{is a vector of integers representing the start and end for the forcing period
in temperate trees. Numbers must be provided in Julian date (day of the year).}

\item{Krig_warn}{is a boolean parameter passed to the \code{\link[fields:Krig]{Krig}} function. Default is
set to \code{TRUE} following the recommendation of the authors of the package. For detailed information, please see the documentation
of the function.}

\item{x_axis_name}{is a character string that allows the user modifying the default label used in the x axis.}

\item{y_axis_name}{is a character string that allows the user modifying the default label used in the y axis.}

\item{legend_name}{is a character string that allows the user modifying the default label used in the legend.}

\item{contour_line_color}{is a character string representing the color used to draw the contour lines.
Default is set to black. If \code{NA} is used, the function will remove the contour lines with a warning.}

\item{point_color}{is a character string representing the color used to draw the points for actual
observations. Default is set to black. If \code{NA} is used, the function will remove the points with
a warning.}

\item{point_shape}{is a numeric input representing the point shape used to draw the points for actual
observations. Default is set to 19 (filled point). If \code{NA} is used, the function will remove the points with
a warning.}

\item{legend_colors}{is a character string representing the color scale used in the surface plot.
Default is set to \code{NULL} to let the function use the rainbow colors.}

\item{base_size}{is a numeric input representing the relative size of the elements in plot. \code{base_size}
is passed to \code{\link[ggplot2:ggtheme]{ggplot2::theme_bw}} as well as used to determine the size of the
points and contour lines.}

\item{...}{accepts arguments passed to \code{\link[ggplot2:theme]{ggplot2::theme}}}
}
\value{
\code{plot_phenology_trends()} is expected to return an object of class \code{gg} and \code{ggplot}. This
means that the plot can be later modified by using the syntax \code{'+'} from the
\code{\link{ggplot2}} package (see examples). The plot returned in the function should look as the following:

\if{html}{\figure{rainbowplotexample.png}{options: width='100\%' alt='rainbow_plot example'}}
\if{latex}{\figure{rainbowplotexample.png}{options: width=5.5in}}
}
\description{
The timing of many development stages of temperate trees may depend on temperatures during two
phases (e.g. bloom dates depend on the temperature during both the chilling and forcing phase of dormancy).
\code{plot_phenology_trends()} illustrates this dependency as a colored surface with contour lines by applying an
interpolating procedure with functions in the \code{\link{fields}} package. The plot is implemented
through functions in the \code{\link{ggplot2}} package.
}
\details{
The generation of the color surface is based on the Kriging technique, which is typically used for 
interpolation of spatial data. The use for this particular purpose is a bit experimental.
}
\examples{

# Run a simple plot

plot_phenology_trends(pheno_data = chillR::KA_bloom,
                      weather_data = chillR::KA_weather,
                      chilling_phase = c(306, 350),
                      forcing_phase = c(355, 60))
             
# Customize the aspects of the plot and save it as 'plot'

plot <- plot_phenology_trends(pheno_data = chillR::KA_bloom,
                              weather_data = chillR::KA_weather,
                              chilling_phase = c(306, 350),
                              forcing_phase = c(355, 60),
                              x_axis_name = "Temperatura en el periodo de frio (Celsius)",
                              y_axis_name = "Temperatura en el periodo de forzado (Celsius)",
                              legend_name = "Fecha de floracion\n(dia juliano)",
                              contour_line_color = "white",
                              point_color = "blue4",
                              point_shape = 4,
                              legend_colors = NULL,
                              base_size = 14,
                              legend.position = "bottom",
                              axis.title = ggplot2::element_text(family = "serif"))

plot

# Modify the plot object with the syntax from ggplot2.
# Be aware that the following code overrides the modifications
# done by the argument '...' in the main function

plot + ggplot2::theme_classic(base_size = 14)

}
