\name{stack_hourly_temps}

\alias{stack_hourly_temps}

\title{Stacking of hourly temperatures}

\description{This function processes hourly temperatures generated by make_hourly_temps for calculation of chilling and forcing. The chilling function requires
temperatures to be in a long list, and this function prepares them in this way.}

\usage{
stack_hourly_temps(hour_file)
}

\arguments{
  \item{hour_file}{   this is a data frame of hourly temperatures, as generated by make_hourly_temps. It has columns describing the date (Year+JDay or
Year+Month+Day) and 24 columns called Hour_1 ... Hour_24 that contain hourly temperatures.}
}

\value{   data frame containing all the columns of the input data frame, except the hourly temperatures. Instead, two columns are added: Hour is the hour of the 
day, and Temp is the corresponding modeled mean temperature for that hour.}

\references{
Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat requirements of cherry trees - a statistical approach. International Journal of Biometeorology 57,679-689.
}
\author{Eike Luedeling}


\examples{

weather<-make_all_day_table(KA_weather[which(KA_weather$Year>2004),])
weather[,"Tmin"]<-interpolate_gaps(weather[,"Tmin"])$interp
weather[,"Tmax"]<-interpolate_gaps(weather[,"Tmax"])$interp

THourly<-make_hourly_temps(50.4,weather)

stack<-stack_hourly_temps(hour_file=THourly)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ utility }
