% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_treeshap_minimal_port.r
\name{set_reference_dataset}
\alias{set_reference_dataset}
\title{Set reference dataset}
\usage{
set_reference_dataset(unified_model, x)
}
\arguments{
\item{unified_model}{Unified model representation of the model created with a (model).unify function. (\code{\link{model_unified.object}}).}

\item{x}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model.}
}
\value{
\code{\link{model_unified.object}}. Unified representation of the model as created with a (model).unify function,
but with changed reference dataset (Cover column containing updated values).
}
\description{
Change a dataset used as reference for calculating SHAP values.
Reference dataset is initially set with \code{data} argument in unifying function.
Usually reference dataset is dataset used to train the model.
Important property of reference dataset is that SHAPs for each observation add up to its deviation from mean prediction of reference dataset.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Fit a model:
gbm_model <- gbm::gbm(
  formula = Y ~ .,
  data = data.frame(X, Y),
  distribution = "gaussian",
  n.trees = 50,
  interaction.depth = 4,
  n.cores = 1)
unified <- gbm.unify(gbm_model, X)
set_reference_dataset(unified, X[50:100, ])
}
\seealso{
\code{\link{unify_tree_model}}, a wrapper function unifying these models.
\code{\link{lightgbm.unify}} for \code{\link[lightgbm:lightgbm]{LightGBM models}}
\code{\link{gbm.unify}} for \code{\link[gbm:gbm]{GBM models}}
\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}
\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}
\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
