% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkCharacter.R
\name{checkCharacter}
\alias{checkCharacter}
\alias{check_character}
\alias{assertCharacter}
\alias{assert_character}
\alias{testCharacter}
\alias{test_character}
\alias{expect_character}
\title{Check if an argument is a vector of type character}
\usage{
checkCharacter(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE)

check_character(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE)

assertCharacter(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE, .var.name = vname(x), add = NULL)

assert_character(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE, .var.name = vname(x), add = NULL)

testCharacter(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE)

test_character(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE)

expect_character(x, min.chars = NULL, pattern = NULL, fixed = NULL,
  ignore.case = FALSE, any.missing = TRUE, all.missing = TRUE,
  len = NULL, min.len = NULL, max.len = NULL, unique = FALSE,
  names = NULL, null.ok = FALSE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{min.chars}{[\code{integer(1)}]\cr
Minimum number of characters for each element of \code{x}.}

\item{pattern}{[\code{character(1L)}]\cr
Regular expression as used in \code{\link[base]{grepl}}.
All non-missing elements of \code{x} must comply to this pattern.}

\item{fixed}{[\code{character(1)}]\cr
Substring to detect in \code{x}. Will be used as \code{pattern} in \code{\link[base]{grepl}}
with option \code{fixed} set to \code{TRUE}.
All non-missing elements of \code{x} must contain this substring.}

\item{ignore.case}{[\code{logical(1)}]\cr
See \code{\link[base]{grepl}}. Default is \code{FALSE}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertCharacter}/\code{assert_character} return 
 \code{x} invisibly, whereas
 \code{checkCharacter}/\code{check_character} and 
 \code{testCharacter}/\code{test_character} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertCharacter}/\code{assert_character}
 throws an error message, 
 \code{testCharacter}/\code{test_character}
 returns \code{FALSE},
 and \code{checkCharacter} returns a string with the error message.
 The function \code{expect_character} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a vector of type character
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testCharacter(letters, min.len = 1, any.missing = FALSE)
testCharacter(letters, min.chars = 2)
testCharacter("example", pattern = "xa")
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkComplex}},
  \code{\link{checkDataFrame}}, \code{\link{checkDate}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNull}}, \code{\link{checkNumeric}},
  \code{\link{checkVector}}
}
