% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkAtomic.R
\name{checkAtomic}
\alias{checkAtomic}
\alias{check_atomic}
\alias{assertAtomic}
\alias{assert_atomic}
\alias{testAtomic}
\alias{test_atomic}
\alias{expect_atomic}
\title{Check that an argument is an atomic vector}
\usage{
checkAtomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

check_atomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

assertAtomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  .var.name = vname(x), add = NULL)

assert_atomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  .var.name = vname(x), add = NULL)

testAtomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

test_atomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

expect_atomic(x, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertAtmoic}/\code{assert_atmoic} return 
 \code{x} invisibly, whereas
 \code{checkAtmoic}/\code{check_atmoic} and 
 \code{testAtmoic}/\code{test_atmoic} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertAtmoic}/\code{assert_atmoic}
 throws an error message, 
 \code{testAtmoic}/\code{test_atmoic}
 returns \code{FALSE},
 and \code{checkAtmoic} returns a string with the error message.
 The function \code{expect_atmoic} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
For the definition of \dQuote{atomic}, see \code{\link[base]{is.atomic}}.
}
\examples{
testAtomic(letters, min.len = 1L, any.missing = FALSE)
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkCharacter}}, \code{\link{checkComplex}},
  \code{\link{checkDataFrame}}, \code{\link{checkDate}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNull}}, \code{\link{checkNumeric}},
  \code{\link{checkVector}}

Other atomicvector: \code{\link{checkAtomicVector}},
  \code{\link{checkVector}}
}
